/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/precomp_core.h>  // Only for precomp. headers, include all libmrpt-core headers. 



#include <mrpt/poses/CPose3DPDF.h>

#include <mrpt/poses/CPose3DPDFGaussian.h>
#include <mrpt/poses/CPose3DPDFSOG.h>
#include <mrpt/poses/CPose3DPDFParticles.h>

#include <mrpt/poses/CPosePDFGaussian.h>
#include <mrpt/poses/CPosePDFSOG.h>
#include <mrpt/poses/CPosePDFParticles.h>


using namespace mrpt::poses;
using namespace std;

IMPLEMENTS_VIRTUAL_SERIALIZABLE( CPose3DPDF, CSerializable, mrpt::poses )

/*---------------------------------------------------------------
					getEstimatedCovarianceEntropy
  ---------------------------------------------------------------*/
double  CPose3DPDF::getEstimatedCovarianceEntropy()
{
	CMatrix		cov = getEstimatedCovariance();

	return log( pow(M_2PI*2.718281828,3.0))*cov.det();
}

/*---------------------------------------------------------------
					copyFrom2D
  ---------------------------------------------------------------*/
CPose3DPDF* CPose3DPDF::createFrom2D(const CPosePDF &o)
{
	MRPT_TRY_START

	if (o.GetRuntimeClass()==CLASS_ID(CPosePDFGaussian))
	{
		CPose3DPDFGaussian	*newObj = new CPose3DPDFGaussian();
		const CPosePDFGaussian    *obj = static_cast<const CPosePDFGaussian *>( &o );

		newObj->mean = CPose3D( obj->mean );
		CMatrix  COV(obj->cov);
		COV.setSize(6,6);

		// Move covariances: phi<->z
		COV(3,3)=COV(2,2); COV(2,2)=0;
		COV(0,3)=COV(3,0) = COV(0,2); COV(0,2)=COV(2,0)=0;
		COV(1,3)=COV(3,1) = COV(1,2); COV(1,2)=COV(2,1)=0;
		newObj->cov=COV;

		return newObj;
	}
	else
		if (o.GetRuntimeClass()==CLASS_ID(CPosePDFParticles))
		{
			const CPosePDFParticles    *obj = static_cast<const CPosePDFParticles*>( &o );
			CPose3DPDFParticles	*newObj = new CPose3DPDFParticles(obj->size());

			CPosePDFParticles::CParticleList::const_iterator  it1;
			CPose3DPDFParticles::CParticleList::iterator      it2;
			for (it1=obj->m_particles.begin(),it2=newObj->m_particles.begin();it1!=obj->m_particles.end();it1++,it2++)
			{
				it2->log_w = it1->log_w;
				(*it2->d) = (*it1->d);
			}

			return newObj;
		}
		else
			THROW_EXCEPTION("Class of object not supported by this method!");

	MRPT_TRY_END
}

