/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CMessageQueue_H
#define  CMessageQueue_H

#include <mrpt/utils/CMessage.h>
#include <mrpt/synch/CCriticalSection.h>

#include <queue>

namespace mrpt
{
namespace utils
{
	/** A thread-safe class for message passing between threads. */
	class MRPTDLLIMPEXP  CMessageQueue
	{
	protected:
		std::queue< CMessage* >		m_msgs; //!< The queue of messages. Memory is freed at destructor or by clients gathering messages.

		synch::CCriticalSection			m_csQueue; //!< The critical section

	public:
		CMessageQueue();
		virtual ~CMessageQueue();

		void clear(); //!< Clear the queue of messages, freeing memory as required.

		void push( CMessage *msg );  //!< Insert a new message in the queue - The object must be created with "new", and do not delete is after calling this, it must be deleted later.

		/** Retrieve the next message in the queue, or NULL if there is no message.
		  *  The user MUST call "delete" with the returned object after use.
		  */
		CMessage *get( );

		bool empty() const;  //!< Return true if there are no messages.

	}; // End of class def.

	} // End of namespace
} // end of namespace
#endif
