# SuiteSparse: (for Cholmod & CSparse)
# ----------------------------
FIND_PACKAGE(SuiteSparse)

SET(CMAKE_MRPT_HAS_CHOLMOD 0)
SET(CMAKE_MRPT_HAS_CHOLMOD_SYSTEM 0)
IF(CHOLMOD_FOUND)
	IF($ENV{VERBOSE})
		MESSAGE(STATUS "Choldmod: includedir: ${CHOLMOD_INCLUDE_DIR}")
		MESSAGE(STATUS "          libs: ${CHOLMOD_LIBRARIES}")
	ENDIF($ENV{VERBOSE})

	INCLUDE_DIRECTORIES(${CHOLMOD_INCLUDE_DIR})
	APPEND_MRPT_LIBS(${CHOLMOD_LIBRARIES})

	SET(CMAKE_MRPT_HAS_CHOLMOD 1)
	SET(CMAKE_MRPT_HAS_CHOLMOD_SYSTEM 1)
ENDIF(CHOLMOD_FOUND)

# SuiteSparse: CSparse
# ----------------------------
IF(CSPARSE_FOUND)
	IF($ENV{VERBOSE})
		MESSAGE(STATUS "CSparse: includedir: ${CSPARSE_INCLUDE_DIR}")
		MESSAGE(STATUS "         libs: ${CSPARSE_LIBRARY}")
	ENDIF($ENV{VERBOSE})

	INCLUDE_DIRECTORIES(${CSPARSE_INCLUDE_DIR})
	APPEND_MRPT_LIBS(${CSPARSE_LIBRARY})

	SET(CMAKE_MRPT_HAS_CSPARSE 1)
	SET(CMAKE_MRPT_HAS_CSPARSE_SYSTEM 1)
ELSE(CSPARSE_FOUND)
	# Default: use embedded version
	SET(CMAKE_MRPT_HAS_CSPARSE 1)
	SET(CMAKE_MRPT_HAS_CSPARSE_SYSTEM 0)
ENDIF(CSPARSE_FOUND)
