from typing import Any, ClassVar, List

from typing import overload
import mrpt.pymrpt.std.chrono
LVL_DEBUG: VerbosityLevel
LVL_ERROR: VerbosityLevel
LVL_INFO: VerbosityLevel
LVL_WARN: VerbosityLevel
NUMBER_OF_VERBOSITY_LEVELS: VerbosityLevel
ppHigh: TProcessPriority
ppIdle: TProcessPriority
ppNormal: TProcessPriority
ppVeryHigh: TProcessPriority
tpHigh: TThreadPriority
tpHigher: TThreadPriority
tpHighest: TThreadPriority
tpLow: TThreadPriority
tpLower: TThreadPriority
tpLowests: TThreadPriority
tpNormal: TThreadPriority

class CControlledRateTimer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rate_hz: float) -> None: ...
    @overload
    def __init__(self, arg0: CControlledRateTimer) -> None: ...
    @overload
    def actualControlledRate(self) -> float: ...
    @overload
    def actualControlledRate() -> double: ...
    def assign(self) -> CControlledRateTimer: ...
    @overload
    def controllerParam_Kp(self) -> float: ...
    @overload
    def controllerParam_Kp() -> double: ...
    @overload
    def controllerParam_Kp(self, v: float) -> None: ...
    @overload
    def controllerParam_Kp(double) -> void: ...
    @overload
    def controllerParam_Ti(self) -> float: ...
    @overload
    def controllerParam_Ti() -> double: ...
    @overload
    def controllerParam_Ti(self, v: float) -> None: ...
    @overload
    def controllerParam_Ti(double) -> void: ...
    @overload
    def estimatedRate(self) -> float: ...
    @overload
    def estimatedRate() -> double: ...
    @overload
    def estimatedRateRaw(self) -> float: ...
    @overload
    def estimatedRateRaw() -> double: ...
    @overload
    def followErrorRatioToRaiseWarning(self) -> float: ...
    @overload
    def followErrorRatioToRaiseWarning() -> double: ...
    @overload
    def followErrorRatioToRaiseWarning(self, v: float) -> None: ...
    @overload
    def followErrorRatioToRaiseWarning(double) -> void: ...
    @overload
    def lowPassParam_a0(self) -> float: ...
    @overload
    def lowPassParam_a0() -> double: ...
    @overload
    def lowPassParam_a0(self, v: float) -> None: ...
    @overload
    def lowPassParam_a0(double) -> void: ...
    @overload
    def setRate(self, rate_hz: float) -> None: ...
    @overload
    def setRate(constdouble) -> void: ...
    @overload
    def sleep(self) -> bool: ...
    @overload
    def sleep() -> bool: ...

class CDirectoryExplorer:
    class TFileInfo:
        accessTime: int
        fileSize: int
        isDir: bool
        isSymLink: bool
        modTime: int
        name: str
        wholePath: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CDirectoryExplorer.TFileInfo) -> None: ...
        def assign(self) -> CDirectoryExplorer.TFileInfo: ...
    def __init__(self) -> None: ...
    def explore(self, *args, **kwargs) -> Any: ...
    def filterByExtension(self, *args, **kwargs) -> Any: ...
    def sortByName(self, *args, **kwargs) -> Any: ...

class CFileSystemWatcher:
    class TFileSystemChange:
        eventAccessed: bool
        eventCloseWrite: bool
        eventCreated: bool
        eventDeleted: bool
        eventModified: bool
        eventMovedFrom: bool
        eventMovedTo: bool
        isDir: bool
        path: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CFileSystemWatcher.TFileSystemChange) -> None: ...
        def assign(self) -> CFileSystemWatcher.TFileSystemChange: ...
    @overload
    def __init__(self, path: str) -> None: ...
    @overload
    def __init__(self, arg0: CFileSystemWatcher) -> None: ...
    def assign(self) -> CFileSystemWatcher: ...

class CObservable:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservable) -> None: ...
    def assign(self) -> CObservable: ...

class CObserver:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObserver) -> None: ...
    def assign(self) -> CObserver: ...
    @overload
    def observeBegin(self, obj: CObservable) -> None: ...
    @overload
    def observeBegin(classmrpt) -> void: ...
    def observeEnd(self, obj: CObservable) -> None: ...

class COutputLoggerStreamWrapper:
    def __init__(self, *args, **kwargs) -> None: ...

class CRateTimer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rate_hz: float) -> None: ...
    @overload
    def __init__(self, arg0: CRateTimer) -> None: ...
    def assign(self) -> CRateTimer: ...
    @overload
    def rate(self) -> float: ...
    @overload
    def rate(Hz) -> Any: ...
    @overload
    def rate() -> double: ...
    @overload
    def setRate(self, rate_hz: float) -> None: ...
    @overload
    def setRate(constdouble) -> void: ...
    @overload
    def sleep(self) -> bool: ...
    @overload
    def sleep() -> bool: ...

class CTicTac:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CTicTac) -> None: ...
    @overload
    def Tac(self) -> float: ...
    @overload
    def Tac() -> double: ...
    @overload
    def Tic(self) -> None: ...
    @overload
    def Tic() -> void: ...
    def assign(self) -> CTicTac: ...

class CTimeLogger:
    class TCallStats:
        last_t: float
        max_t: float
        mean_t: float
        min_t: float
        n_calls: int
        total_t: float
        def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, enabled: bool) -> None: ...
    @overload
    def __init__(self, enabled: bool, name: str) -> None: ...
    @overload
    def __init__(self, enabled: bool, name: str, keep_whole_history: bool) -> None: ...
    @overload
    def __init__(self, arg0: CTimeLogger) -> None: ...
    def assign(self, o: CTimeLogger) -> CTimeLogger: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear(self, deep_clear: bool) -> None: ...
    @overload
    def clear() -> Any: ...
    @overload
    def clear(bool) -> void: ...
    @overload
    def disable(self) -> None: ...
    @overload
    def disable() -> void: ...
    @overload
    def dumpAllStats(self) -> None: ...
    @overload
    def dumpAllStats(self, column_width: int) -> None: ...
    @overload
    def dumpAllStats(size_t) -> void: ...
    @overload
    def enable(self) -> None: ...
    @overload
    def enable(self, enabled: bool) -> None: ...
    @overload
    def enable(bool) -> void: ...
    @overload
    def enableKeepWholeHistory(self) -> None: ...
    @overload
    def enableKeepWholeHistory(self, enable: bool) -> None: ...
    @overload
    def enableKeepWholeHistory(bool) -> void: ...
    @overload
    def getLastTime(self, name: str) -> float: ...
    @overload
    def getLastTime(conststd) -> double: ...
    @overload
    def getMeanTime(self, name: str) -> float: ...
    @overload
    def getMeanTime(conststd) -> double: ...
    def getName(self) -> str: ...
    @overload
    def getStatsAsText(self) -> str: ...
    @overload
    def getStatsAsText(self, column_width: int) -> str: ...
    @overload
    def isEnabled(self) -> bool: ...
    @overload
    def isEnabled() -> bool: ...
    @overload
    def isEnabledKeepWholeHistory(self) -> bool: ...
    @overload
    def isEnabledKeepWholeHistory() -> bool: ...
    @overload
    def saveToCSVFile(self, csv_file: str) -> None: ...
    @overload
    def saveToCSVFile(conststd) -> void: ...
    @overload
    def saveToMFile(self, m_file: str) -> None: ...
    @overload
    def saveToMFile(conststd) -> void: ...
    @overload
    def setName(self, name: str) -> None: ...
    @overload
    def setName(conststd) -> void: ...

class CTimeLoggerEntry:
    def __init__(self, arg0: CTimeLoggerEntry) -> None: ...
    @overload
    def stop(self) -> None: ...
    @overload
    def stop() -> void: ...

class CTimeLoggerSaveAtDtor:
    def __init__(self, tm: CTimeLogger) -> None: ...

class ConsoleBackgroundColor:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    BLACK: ClassVar[ConsoleBackgroundColor] = ...
    BLUE: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_BLACK: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_BLUE: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_CYAN: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_GREEN: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_MAGENTA: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_RED: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_WHITE: ClassVar[ConsoleBackgroundColor] = ...
    BRIGHT_YELLOW: ClassVar[ConsoleBackgroundColor] = ...
    CYAN: ClassVar[ConsoleBackgroundColor] = ...
    DEFAULT: ClassVar[ConsoleBackgroundColor] = ...
    GREEN: ClassVar[ConsoleBackgroundColor] = ...
    MAGENTA: ClassVar[ConsoleBackgroundColor] = ...
    RED: ClassVar[ConsoleBackgroundColor] = ...
    WHITE: ClassVar[ConsoleBackgroundColor] = ...
    YELLOW: ClassVar[ConsoleBackgroundColor] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ConsoleForegroundColor:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    BLACK: ClassVar[ConsoleForegroundColor] = ...
    BLUE: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_BLACK: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_BLUE: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_CYAN: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_GREEN: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_MAGENTA: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_RED: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_WHITE: ClassVar[ConsoleForegroundColor] = ...
    BRIGHT_YELLOW: ClassVar[ConsoleForegroundColor] = ...
    CYAN: ClassVar[ConsoleForegroundColor] = ...
    DEFAULT: ClassVar[ConsoleForegroundColor] = ...
    GREEN: ClassVar[ConsoleForegroundColor] = ...
    MAGENTA: ClassVar[ConsoleForegroundColor] = ...
    RED: ClassVar[ConsoleForegroundColor] = ...
    WHITE: ClassVar[ConsoleForegroundColor] = ...
    YELLOW: ClassVar[ConsoleForegroundColor] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ConsoleTextStyle:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    BLINKING: ClassVar[ConsoleTextStyle] = ...
    BOLD: ClassVar[ConsoleTextStyle] = ...
    DIM: ClassVar[ConsoleTextStyle] = ...
    INVISIBLE: ClassVar[ConsoleTextStyle] = ...
    ITALIC: ClassVar[ConsoleTextStyle] = ...
    REGULAR: ClassVar[ConsoleTextStyle] = ...
    REVERSE: ClassVar[ConsoleTextStyle] = ...
    UNDERLINED: ClassVar[ConsoleTextStyle] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TProcessPriority:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    ppHigh: ClassVar[TProcessPriority] = ...
    ppIdle: ClassVar[TProcessPriority] = ...
    ppNormal: ClassVar[TProcessPriority] = ...
    ppVeryHigh: ClassVar[TProcessPriority] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TThreadPriority:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    tpHigh: ClassVar[TThreadPriority] = ...
    tpHigher: ClassVar[TThreadPriority] = ...
    tpHighest: ClassVar[TThreadPriority] = ...
    tpLow: ClassVar[TThreadPriority] = ...
    tpLower: ClassVar[TThreadPriority] = ...
    tpLowests: ClassVar[TThreadPriority] = ...
    tpNormal: ClassVar[TThreadPriority] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TTimeParts:
    day: int
    day_of_week: int
    daylight_saving: int
    hour: int
    minute: int
    month: int
    second: float
    year: int
    def __init__(self) -> None: ...

class VerbosityLevel:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    LVL_DEBUG: ClassVar[VerbosityLevel] = ...
    LVL_ERROR: ClassVar[VerbosityLevel] = ...
    LVL_INFO: ClassVar[VerbosityLevel] = ...
    LVL_WARN: ClassVar[VerbosityLevel] = ...
    NUMBER_OF_VERBOSITY_LEVELS: ClassVar[VerbosityLevel] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class WorkerThreadsPool:
    class queue_policy_t:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        POLICY_DROP_OLD: ClassVar[WorkerThreadsPool.queue_policy_t] = ...
        POLICY_FIFO: ClassVar[WorkerThreadsPool.queue_policy_t] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    POLICY_DROP_OLD: ClassVar[WorkerThreadsPool.queue_policy_t] = ...
    POLICY_FIFO: ClassVar[WorkerThreadsPool.queue_policy_t] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, num_threads: int) -> None: ...
    @overload
    def __init__(self, num_threads: int, p) -> None: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def pendingTasks(self) -> int: ...
    @overload
    def resize(self, num_threads: int) -> None: ...
    @overload
    def resize(std) -> void: ...

class mrptEvent:
    timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: mrptEvent) -> None: ...
    @overload
    def __init__(self, arg0: mrptEvent) -> None: ...
    def assign(self) -> mrptEvent: ...

class mrptEventOnDestroy(mrptEvent):
    def __init__(self, obj) -> None: ...
    def assign(self) -> mrptEventOnDestroy: ...

def InvalidTimeStamp() -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
def MRPT_getCompilationDate() -> str: ...
def MRPT_getVersion() -> str: ...
def buildTimestampFromParts(p: TTimeParts) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
def buildTimestampFromPartsLocalTime(p: TTimeParts) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
def changeCurrentProcessPriority(*args, **kwargs) -> Any: ...
@overload
def changeCurrentThreadPriority(priority: TThreadPriority) -> None: ...
@overload
def changeCurrentThreadPriority(enummrpt) -> void: ...
@overload
def clearConsole() -> None: ...
@overload
def clearConsole() -> void: ...
@overload
def compute_CRC16(data: int, len: int) -> int: ...
@overload
def compute_CRC16(data: int, len: int, gen_pol: int) -> int: ...
@overload
def compute_CRC32(data: int, len: int) -> int: ...
@overload
def compute_CRC32(data: int, len: int, gen_pol: int) -> int: ...
@overload
def consoleColorAndStyle(fg: ConsoleForegroundColor) -> None: ...
@overload
def consoleColorAndStyle(fg: ConsoleForegroundColor, bg: ConsoleBackgroundColor) -> None: ...
@overload
def consoleColorAndStyle(fg: ConsoleForegroundColor, bg: ConsoleBackgroundColor, style: ConsoleTextStyle) -> None: ...
@overload
def consoleColorAndStyle(fg: ConsoleForegroundColor, bg: ConsoleBackgroundColor, style: ConsoleTextStyle, applyToStdErr: bool) -> None: ...
@overload
def copyFile(sourceFile: str, targetFile: str) -> bool: ...
@overload
def copyFile(sourceFile: str, targetFile: str, outErrStr: str) -> bool: ...
@overload
def createDirectory(dirName: str) -> bool: ...
@overload
def createDirectory(conststd) -> bool: ...
def dateTimeLocalToString(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> str: ...
def dateTimeToString(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> str: ...
def dateToString(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> str: ...
@overload
def deleteFile(fileName: str) -> bool: ...
@overload
def deleteFile(conststd) -> bool: ...
@overload
def deleteFiles(s: str) -> None: ...
@overload
def deleteFiles(conststd) -> void: ...
@overload
def deleteFilesInDirectory(s: str) -> bool: ...
@overload
def deleteFilesInDirectory(s: str, deleteDirectoryAsWell: bool) -> bool: ...
@overload
def deleteFilesInDirectory(conststd, bool) -> bool: ...
@overload
def directoryExists(fileName: str) -> bool: ...
@overload
def directoryExists(conststd) -> bool: ...
@overload
def executeCommand(command: str) -> int: ...
@overload
def executeCommand(command: str, output: str) -> int: ...
@overload
def executeCommand(command: str, output: str, mode: str) -> int: ...
@overload
def extractDayTimeFromTimestamp(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> float: ...
@overload
def extractDayTimeFromTimestamp(constmrpt) -> double: ...
def extractFileDirectory(filePath: str) -> str: ...
def extractFileExtension(*args, **kwargs) -> Any: ...
def extractFileName(filePath: str) -> str: ...
@overload
def fileExists(fileName: str) -> bool: ...
@overload
def fileExists(conststd) -> bool: ...
def fileNameChangeExtension(filename: str, newExtension: str) -> str: ...
@overload
def fileNameStripInvalidChars(filename: str) -> str: ...
@overload
def fileNameStripInvalidChars(filename: str, replacement_to_invalid_chars: str) -> str: ...
def filePathSeparatorsToNative(filePath: str) -> str: ...
def find_mrpt_shared_dir() -> str: ...
def firstNLines(str: str, n: int) -> str: ...
def formatTimeInterval(timeSeconds: float) -> str: ...
def getCurrentTime() -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
@overload
def getFileModificationTime(filename: str) -> int: ...
@overload
def getFileModificationTime(conststd) -> long: ...
@overload
def getFileSize(fileName: str) -> int: ...
@overload
def getFileSize(conststd) -> uint64_t: ...
def getMRPTLicense() -> str: ...
@overload
def getMemoryUsage() -> int: ...
@overload
def getMemoryUsage() -> unsignedlong: ...
def getShareMRPTDir() -> str: ...
def getTempFileName() -> str: ...
def getcwd() -> str: ...
def global_profiler_enter(func_name: str) -> None: ...
def global_profiler_getref() -> CTimeLogger: ...
def global_profiler_leave(func_name: str) -> None: ...
def intervalFormat(seconds: float) -> str: ...
@overload
def launchProcess(command: str) -> bool: ...
@overload
def launchProcess(conststd) -> bool: ...
def lowerCase(str: str) -> str: ...
def md5(str: str) -> str: ...
def now() -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
@overload
def now_double() -> float: ...
@overload
def now_double() -> double: ...
def nthOccurrence(str: str, strToFind: str, nth: int) -> int: ...
def pathJoin(paths: List[str]) -> str: ...
@overload
def pause() -> None: ...
@overload
def pause(msg: str) -> None: ...
@overload
def pause(conststd) -> void: ...
@overload
def progress(progressRatio0to1: float, barLength: int) -> str: ...
@overload
def progress(progressRatio0to1: float, barLength: int, encloseInSquareBrackets: bool) -> str: ...
@overload
def renameFile(oldFileName: str, newFileName: str) -> bool: ...
@overload
def renameFile(oldFileName: str, newFileName: str, error_msg: str) -> bool: ...
@overload
def rightPad(str: str, total_len: int) -> str: ...
@overload
def rightPad(str: str, total_len: int, truncate_if_larger: bool) -> str: ...
def strCmp(s1: str, s2: str) -> bool: ...
def strCmpI(s1: str, s2: str) -> bool: ...
def strStarts(str: str, subStr: str) -> bool: ...
def strStartsI(str: str, subStr: str) -> bool: ...
@overload
def stringListAsString(lst: List[str], out: str) -> None: ...
@overload
def stringListAsString(lst: List[str], out: str, newline: str) -> None: ...
@overload
def stringListAsString(constclassstd, std, conststd) -> void: ...
@overload
def thread_name(name: str) -> None: ...
@overload
def thread_name(conststd) -> void: ...
@overload
def thread_name() -> str: ...
def timeDifference(t_first: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, t_later: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> float: ...
@overload
def timeLocalToString(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> str: ...
@overload
def timeLocalToString(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, secondFractionDigits: int) -> str: ...
def timeToString(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> str: ...
@overload
def time_tToTimestamp(t: float) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
@overload
def time_tToTimestamp(t: int) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
def timestampAdd(tim: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, num_seconds: float) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
@overload
def timestampToDouble(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> float: ...
@overload
def timestampToDouble(constmrpt) -> double: ...
@overload
def timestampToParts(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, p: TTimeParts) -> None: ...
@overload
def timestampToParts(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, p: TTimeParts, localTime: bool) -> None: ...
@overload
def timestampToParts(mrpt, structmrpt, bool) -> void: ...
@overload
def timestampTotime_t(t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> float: ...
@overload
def timestampTotime_t(constmrpt) -> double: ...
@overload
def toAbsolutePath(path: str) -> str: ...
@overload
def toAbsolutePath(path: str, resolveToCanonical: bool) -> str: ...
@overload
def tokenize(inString: str, inDelimiters: str, outTokens: List[str]) -> None: ...
@overload
def tokenize(inString: str, inDelimiters: str, outTokens: List[str], skipBlankTokens: bool) -> None: ...
def trim(str: str) -> str: ...
@overload
def unitsFormat(val: float) -> str: ...
@overload
def unitsFormat(val: float, nDecimalDigits: int) -> str: ...
@overload
def unitsFormat(val: float, nDecimalDigits: int, middle_space: bool) -> str: ...
def upperCase(str: str) -> str: ...
