#include <stdio.h>
#include "MRI.h"

void
MRI_ApplyNoiseMap (MRI *mri, char *filename)
{
	FILE	*f;
	char	buffer[1024];
	int	i, j, c;
	int	width, height, depth;
	unsigned short *map;

	f = fopen (filename, "r");
	if (f == NULL) {
		fprintf (stderr, "ApplyNoiseMap: cannot open %s\n", filename);
		return;
	}
	i = 0;
	for (;;) {
		c = getc (f);
		if (c == EOF || c == '\n') {
			buffer[i] = '\0';
			break;
		}
		buffer[i++] = c;
	}
	if (sscanf (buffer, "P6 %d %d %d", &width, &height, &depth) != 3) {
		fprintf (stderr, "ApplyNoiseMap: %s is not a NoiseMap\n", filename);
		fclose (f);
		return;
	}
	if (depth != 65535) {
		fprintf (stderr, "ApplyNoiseMap: %s is not a NoiseMap (depth %d)\n", filename, depth);
		fclose (f);
		return;
	}
	if (width != MRI_GetWidth(mri) || height != MRI_GetHeight(mri)) {
		fprintf (stderr, "ApplyNoiseMap: %s doesn't match image size (%dx%d versus %dx%d)\n", filename, width, height, MRI_GetWidth(mri), MRI_GetWidth(mri));
		fclose (f);
		return;
	}
	map = (unsigned short *)malloc(sizeof(unsigned short)*width*height);
	for (i = 0; i < height; i++)
		for (j = 0; j < width; j++) {
			unsigned char c1, c2;
			double scale, base;
			c1 = getc(f) & 0xFF;
			c2 = getc(f) & 0xFF;
			scale = 32768.0 / ((c1 << 8) | c2);
			c1 = getc(f) & 0xFF;
			c2 = getc(f) & 0xFF;
			base = ((c1 << 8) | c2);
			c1 = getc(f) & 0xFF;
			c2 = getc(f) & 0xFF;
			/* Final c1, c2 not used. */
			if ((i & 1) != (j & 1)) {
				int val = (mri->G[i][j] - base) * scale;
				if (val < 0)
					mri->G[i][j] = 0;
				else if (val > 0xFFFF)
					mri->G[i][j] = 0xFFFF;
				else
					mri->G[i][j] = val;
			}
			else if (!(i & 1) && !(j & 1)) {
				int val = (mri->R[i][j] - base) * scale;
				if (val < 0)
					mri->R[i][j] = 0;
				else if (val > 0xFFFF)
					mri->R[i][j] = 0xFFFF;
				else
					mri->R[i][j] = val;
			}
			else {
				int val = (mri->B[i][j] - base) * scale;
				if (val < 0)
					mri->B[i][j] = 0;
				else if (val > 0xFFFF)
					mri->B[i][j] = 0xFFFF;
				else
					mri->B[i][j] = val;
			}
		}
	fclose (f);
}
