#define WAIT_FOR_FILE_DELAY	250	/* sleep when waiting for a file to become available */
#define MAX_N_RE_MATCHES	16	/* max. number of regex matches: used for coloring matches */
#define MIN_N_BUFFERLINES	100	/* number of lines to buffer at minimum */
#define MAX_N_SPAWNED_PROCESSES	16	/* max. nr. of processes executed by matching regexps */

#define TERM_MISC	0
#define TERM_XTERM	1

#ifndef _BSD_SOURCE
#define _BSD_SOURCE	/* don't worry: it'll still work if you don't have
			 * a BSD system
			 */
#endif
#ifndef __USE_BSD
#define __USE_BSD	/* manpage says _BSD_SOURCE, stdlib.h says __USE_BSD */
#endif

#if defined(__FreeBSD__) || defined(linux) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(hpux) || defined(__hpux) || defined(__APPLE__)
#include <ncurses.h>
#define N_CURSES
#else
#include <curses.h>
#endif

#define SEL_WIN		0
#define SEL_SUBWIN	1
#define SEL_FILES	2
#define SEL_CSCHEME	3

typedef struct
{
        char *regex_str;
        regex_t regex;
        char invert_regex;
	char use_regex;

	/* command to run if matches */
	char *cmd;
} re;

typedef struct _subwindow_
{
	char *filename;
	char is_command;
	int fd;		/* read */
	int wfd;	/* write */
	pid_t pid;

	char line_wrap;
	int line_wrap_offset;

	int win_height;

	/* repeatingly start a program */
	int restart;
	char first;
	char do_diff;
	char **bcur, **bprev;
	int ncur, nprev;

	int initial_n_lines_tail;

	char colorize;
	char field_nr;
	char *field_del;
	int color_scheme;

	char hidden;
	char follow_filename;
	char retry_open;

	time_t lastevent;
	double prev_deltat, total_deltat;
	double med;
	double dev;
	int n_events;

	WINDOW *status;
	WINDOW *data;

	int n_re;
	re *pre;

	struct _subwindow_ *next;
} proginfo;

typedef struct
{
	char **Blines;
	proginfo **pi;
	int curpos;
	char markset;
	int maxnlines;
} buffer;

typedef struct
{
	char *name;
	int n;
	int *color;
        regex_t *regex;
} color_scheme;

typedef struct
{
	int scheme_nr;
	regex_t	regex;
} scheme_per_file;

typedef struct
{
	regoff_t start;
	regoff_t end;
	int color_index;
} color_offset_in_line;

typedef struct
{
	char key;
	char *command;
} keybinding;

void do_exit(int sig);
char * select_file(char *input);
char check_no_suppress_lines_filter(proginfo *cur);
char check_filter(proginfo *cur, char *string, regmatch_t **pmatch, char **error, int *matching_regex);
void color_print(WINDOW *win, proginfo *cur, unsigned char *string, regmatch_t *matches, int matching_regex);
int select_window(void);
void toggle_colors(void);

#ifdef _DEBUG
	void LOG(char *str, ...);
#else
	#define LOG(x)
#endif
