#! /bin/sh
#
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.8  03-Mar-1998  miquels@cistron.nl
#
# This file was automatically customized by dh-make on Wed,  6 Jun 2001 11:33:47 +0900

PATH=/sbin:/bin:/usr/sbin:/usr/bin
NAME="murasaki"
DESC="murasaki (Another HotPlug Agent)"

MURASAKI_HOTPLUG=/sbin/hotplug.murasaki
MURASAKI_PRELOAD=/etc/murasaki/murasaki.preload
MURASAKI_AUTOSETUP=/etc/murasaki/bin/auto_setup

DEFAULT_HOTPLUG=/sbin/hotplug
PROC_PATH=/proc/sys/kernel/hotplug

MODPROBE=/sbin/modprobe
MODPROBE_OPT=-as

GREP="/bin/grep -q"
MOUNT="/bin/mount"
PROC_FS=/proc/filesystems
PROC_MNT=/proc/mounts
PROC_USB=/proc/bus/usb

LOCK_FILE=/var/lock/subsys/murasaki

# OVERWRITE: if you want to setup automatically every boot,
#            you choose 'true'
OVERWRITE=false

# INIT:on/off:if you want to initialize usb and pci device on booting,
#                        you set 'on'
INIT=on

# MURASAKI_BEEP:on/off:if you like to beep when your PC boots, you set 'on'
MURASAKI_BEEP=off

test -f $MURASAKI_HOTPLUG || exit 0
test -e $PROC_PATH || exit 0

set -e

export MURASAKI_BEEP

initialize(){
	for f in /sbin/murasaki_init.*
	do
		$f
	done
}

case "$1" in
  start)
#	echo -n "Starting $DESC: $NAME"
	echo "Starting $DESC: $NAME"
	if [ ! -f ${MURASAKI_PRELOAD} -o ${OVERWRITE} = 'true' ]; then
		${MURASAKI_AUTOSETUP} > ${MURASAKI_PRELOAD}
	fi
	if [ -s ${MURASAKI_PRELOAD} ]; then
		${MODPROBE} ${MODPROBE_OPT} `cat ${MURASAKI_PRELOAD}`
	fi
	##
	## Mount the usbdevfs to /proc/bus/usb if it doesn't mount yet.
	##
	if $GREP usbdevfs ${PROC_FS} && ! ${GREP} usbdevfs ${PROC_MNT}; then
		echo "Mount the usbdevfs to /proc/bus/usb."
		${MOUNT} -t usbdevfs usbdevfs ${PROC_USB}
	fi

	touch ${LOCK_FILE}
	echo ${MURASAKI_HOTPLUG} > ${PROC_PATH}
	if [ $INIT = 'on' ];then
	initialize
	fi
	echo "done"
	;;
  stop)
	echo -n "Stopping $DESC: "
	rm -f ${LOCK_FILE}
	echo ${DEFAULT_HOTPLUG} > ${PROC_PATH}
	echo "$NAME."
	;;
  #reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	# echo "Reloading $DESC configuration files."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
  #;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	/etc/init.d/murasaki stop
	sleep 1
	/etc/init.d/murasaki start
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
