/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: print.c,v 1.1 2003/04/05 20:32:43 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<unistd.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

void
print_config(void *conf)
{
	MU_pci_config_t *config = conf;

	/* 
	 *	I have not understood class_mask yet.
	 *  So, I use '0' as class_mask instead of appropriate value.
	 */
	syslog(LOG_LEVEL,"MODULE 0x%08x 0x%08x 0x%08x 0x%08x 0x%08x 0x%08x 0x00000000",
		config->id.vendor,config->id.device,
		config->sub_id.vendor,config->sub_id.device,
		config->class,0);
}

void
inform_config(void *conf)
{
	MU_pci_config_t *config = conf;

	syslog(LOG_LEVEL,"vendor:0x%x device:0x%x subvendor:0x%x subdevice 0x%x class:0x%x class_mask:0x%x(ignore)",
		config->id.vendor,config->id.device,
		config->sub_id.vendor,config->sub_id.device,
		config->class,config->class_mask);
}
