/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 3.5 2003/04/20 21:41:02 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

MU_usb_config_t config;

static void
get_info_usb(void)
{
	if (get_id_usb_product(&config) == INVALID)
		exit(1);
	if (get_id_usb_type(&config) == INVALID)
		exit(1);
}

struct mu_op mu_op = {
	device: usb,
	device_name: MU_ARG_USB,
	command: MU_MURASAKI "." MU_ARG_USB,
	mappath: MU_CONF_DIR "/" MU_USBMAP,
	default_mapname: MU_DEFAULT_USBMAP,
	action: ACTION_NONE,
	config: &config,
	get_info: get_info_usb,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
