/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *	$Id: murasaki_input.h,v 1.1 2004/02/19 00:48:37 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_INPUT_H
#define	_MURASAKI_INPUT_H

#include	<asm/types.h>	/* for __u16 */

/* from linux/input.h */
#define	BITS_PER_LONG	sizeof(long)
#define NBITS(x) ((((x)-1)/BITS_PER_LONG)+1)

/* match flags */
#define	INPUT_DEVICE_ID_MATCH_BUS	0x001
#define	INPUT_DEVICE_ID_MATCH_VENDOR	0x002
#define	INPUT_DEVICE_ID_MATCH_PRODUCT	0x004
#define	INPUT_DEVICE_ID_MATCH_VERSION	0x008

#define	INPUT_DEVICE_ID_MATCH_EVBIT	0x010
#define	INPUT_DEVICE_ID_MATCH_KEYBIT	0x020
#define	INPUT_DEVICE_ID_MATCH_RELBIT	0x040
#define	INPUT_DEVICE_ID_MATCH_ABSBIT	0x080
#define	INPUT_DEVICE_ID_MATCH_MSCBIT	0x100
#define	INPUT_DEVICE_ID_MATCH_LEDBIT	0x200
#define	INPUT_DEVICE_ID_MATCH_SNDBIT	0x400
#define	INPUT_DEVICE_ID_MATCH_FFBIT	0x800

#define	EV_MAX	0x1f
#define KEY_MAX	0x1ff
#define REL_MAX	0x0f
#define ABS_MAX	0x3f
#define MSC_MAX	0x07
#define LED_MAX	0x0f
#define SND_MAX	0x07
#define FF_MAX	0x7f

typedef struct {
	char *name;
	unsigned int match_flags;

	__u16 bustype;
	__u16 vendor;
	__u16 product;
	__u16 version;

	unsigned long evbit[NBITS(EV_MAX)];
	unsigned long keybit[NBITS(KEY_MAX)];
	unsigned long relbit[NBITS(REL_MAX)];
	unsigned long absbit[NBITS(ABS_MAX)];
	unsigned long mscbit[NBITS(MSC_MAX)];
	unsigned long ledbit[NBITS(LED_MAX)];
	unsigned long sndbit[NBITS(SND_MAX)];
	unsigned long ffbit[NBITS(FF_MAX)];

	unsigned long driver_info;
} MU_input_config_t;

/* array.c */
extern int get_id_input_array_colon(char *,char *,unsigned long *,int);
extern int get_id_input_array_space_all(mu_op_t *);
/* product.c */
extern int get_id_input_product(mu_op_t *);
/* push_bit.c */
extern char * push_bit(char *,char *,unsigned long *,int );

#endif	/* _MURASAKI_INPUT_H */
