/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: push_bit.c,v 1.2 2004/02/21 07:54:44 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>

static int
top_of_array(unsigned long *array,int array_size)
{
	int i;

	i = array_size - 1;
	if (array[i] == 0)
		return i;
	for(;i >= 0;i--) {
		if(array[i] == 0)
			break;
	}

	return i+1;
}

char *
push_bit(char *ptr,char *name,unsigned long *array,int array_size)
{
	int i;
	
	i = top_of_array(array,array_size);
	if (name != NULL)
		ptr += sprintf(ptr," %s:%lx",name,array[i]);
	else
		ptr += sprintf(ptr," %lx",array[i]);
	for (i++;i < array_size;i++)
		ptr += sprintf(ptr,":%lx",array[i]);

	return ptr;
}
