/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotAster.com>
 *
 *  $Id: debug.c,v 1.2 2004/09/12 07:35:20 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"

/*
 * a external function needs to control this with msg_level.
 */
void
print_args(char *name,char **av)
{
	int i;

	for(i = 0;av[i] != NULL;i++) {
		syslog(LOG_LEVEL,"%s[%d] = \"%s\"",name,i,av[i]);
	}
}

int
get_msg_level(void)
{
	char *ptr;
	int msg_level,default_val = MU_MSG_STD;

	msg_level = check_config_val("message",default_val);
	if (msg_level == -1)
		msg_level = default_val;
	if ((ptr = getenv("MURASAKI_DEBUG")) != NULL) {
		msg_level = atoi(ptr);
	}

	return msg_level;
}
