/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: exec_sysfs.c,v 1.9 2004/09/12 07:37:20 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<sys/wait.h>
#include	<syslog.h>

#include	"murasaki.h"

#define	SCRATCH_BUFSIZE	256

/*
 * init_argument()
 *	argv[0]:hotplug full path
 *	argv[1]:argent name
 */
void
execute_hotplug_sysfs(char *devpath,char *device,int wait_flag,int msg_level)
{
	int i;
	char *argv[4],*envp[16];
	char buf[SCRATCH_BUFSIZE],*scratch;

	switch(fork()) {
	case -1:
		LOG(MU_MSG_QUIET,msg_level,"fork error\n");
		exit(1);
	case 0:
		i = init_argument(argv,envp,device);

		envp[i++] = "MURASAKI_CONF_DIR=" MU_CONF_DIR;
		envp[i++] = "MURASAKI_SCRIPT_DIR=" MU_SCRIPT_DIR;
		scratch = buf;
		envp[i++] = scratch;
		scratch += sprintf(scratch,"MURASAKI_HOTPLUG_NAME=%s",device);
		scratch++;
		envp[i++] = scratch;
		sprintf(scratch,"DEVPATH=%s",devpath);
		envp[i] = NULL;
		execve(argv[0],argv,envp);
		LOG(MU_MSG_QUIET,msg_level,"Exec error\n");
	default:
		if (wait_flag == WAIT_ON)
			wait(NULL);
		break;
	}
}

