/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: list.c,v 3.8 2004/09/12 07:39:37 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"murasaki.h"

/*
 * allocating size + 1 
 * +1 is for last item which content is NULL
 *
 * size: available for input
 * used: sum of used item in list
 */
int
init_list(list_t *lst,int size)
{
	lst->list = (char **)malloc(sizeof(char *) * (size+1));
	if (lst->list == NULL)
		return INVALID;
	lst->size = size;
	lst->used = 0;

	return GOOD;
}

/*
 * re-allocating original size x 2 + 1 
 * +1 is for last item which content is NULL
 *
 * size: available for input
 */
int
realloc_list(list_t *lst)
{
	int size;

	if (lst->size == 0)
		size = LIST_MAX;	/* invalid list data */
	else
		size = lst->size * 2;
	lst->list = (char **)realloc(lst->list,sizeof(char *) * (size+1));
	if (lst->list == NULL) {
		return INVALID;
	}
	lst->size = size;

	return GOOD;
	
}

void
free_list(list_t *lst)
{
	lst->size = 0;
	lst->used = 0;
	free(lst->list);
}

int
find_str_list(list_t *lst, char *name)
{
	int i;

	for(i = 0;i < lst->used;i++) {
		if (strcmp(lst->list[i],name) == 0)
			return i;
	}
	return NOT_FOUND;
}

/*
 * start: starting pointer to a string
 * end:   end pointer + 1 to a string
 */
int
find_mem_list(list_t *lst, char *start,char *end)
{
	int i,len;

	len = end - start;
	for(i = 0;i < lst->used;i++) {
		if (strncmp(lst->list[i],start,len) == 0 &&
			lst->list[i][len] == '\0') {
			return i;
		}
	}
	return NOT_FOUND;
}

/*
 * list[0] -> something ... list[i] -> name , list[i+1] -> NULL
 */ 
int
add_to_list(list_t *lst,char *name,int msg_level)
{
	int idx;

	if ((idx = find_str_list(lst,name)) != NOT_FOUND)
			return GOOD;	/* same one */
	if (lst->used >= lst->size) {
		if (realloc_list(lst) == INVALID) {
			LOG(MU_MSG_QUIET,msg_level,"Memory allocation failed");
			return INVALID;
		}
	}
	lst->list[lst->used++] = name;
	lst->list[lst->used] = NULL;

	return GOOD;
}

#if 0
This function is obsolete.

int
count_of_list(list_t *lst)
{
	return lst->used;
}
#endif

/*
 * This function does NOT focus on speed.
 * The order of modules is important.
 */
void
remove_from_list(list_t *lst,int idx)
{
	int i;

	/* don't exchange to use module's option */
	for(i = idx+1;i < lst->used;i++) {
		lst->list[i-1] = lst->list[i];
	}
	lst->used--;
	lst->list[i-1] = NULL;
}
