/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: main.c,v 3.13 2004/09/12 07:42:25 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/utsname.h>
#include	<string.h>

#include	"murasaki.h"

static int
initialize(mu_op_t *opp)
{
	int size = LIST_MAX;
	struct utsname uts;

	opp->msg_level = get_msg_level();

	if ((init_list(&(opp->module_list),size) == INVALID) ||
		(init_list(&(opp->alias_list),size) == INVALID) ||
		(init_list(&(opp->except_list),size) == INVALID) ||
		(init_list(&(opp->script_list),size) == INVALID) ) {

		LOG_OPP_QUIET("Memory allocation failed");
		return INVALID;
	}

	if (opp->msg_level > MU_MSG_TRACE)
		openlog(opp->command,LOG_PID|LOG_CONS,LOG_DAEMON);
	else
		openlog(opp->command,LOG_PID,LOG_DAEMON);
	/* check beep on/off */
	switch(check_config("beep",opp->msg_level)) {
	case INVALID:
	case ARG_ON:
		break;	/* it may a problem */
	case ARG_OFF:
		FLAG_OFF(opp->flag,FLAG_BEEP);
		break;
	}
	if (uname(&uts) == -1)
		return INVALID;
	if (uts.release[2] >= '5')
		FLAG_ON(opp->flag,FLAG_KERNEL25);
	opp->sysfs = check_sysfs(opp);
	set_devpath(opp);

	return GOOD;
}

static int
final(mu_op_t *opp)
{
#ifdef	KERNEL_JOB
	free_list(&(opp->module_list));
	free_list(&(opp->alias_list));
	free_list(&(opp->except_list));
	free_list(&(opp->script_list));
#endif	/* KERNEL_JOB */

	return GOOD;
}

/*
 * This is common main routine
 *
 * mu_op must be each object. Don't make common main.o.
 */
int
main(int argc,char **argv)
{
	mu_op_t *opp = &mu_op;

	/* kind of murasaki.generic */
	if (strcmp(opp->device_name,MU_ARG_GENERIC) == 0) {
		opp->device_name = argv[1];
	} else if (argc > 1) {
		LOG_OPP_QUIET("%s version %s",MU_MURASAKI,MU_VERSION);
		exit(0);
	}

	if (initialize(opp) == INVALID)
		exit(1);

	if (get_action(opp) == INVALID) {
		LOG_OPP_QUIET("The environment ACTION is invalid");
		exit(1);
	}
	if (opp->get_info && opp->get_info(opp) == INVALID) {
		LOG_OPP_QUIET("The get_info is invalid");
		exit(1);
	}

	/* build module list */
	if (opp->get_list && opp->get_list(opp) == INVALID)
		exit(1);
	/* pre-call */
	if (opp->prepare)
		opp->prepare(opp,PRECALL);
	/* load/unload */
	if (opp->run && opp->run(opp) == INVALID) {
		LOG_OPP_QUIET("fail to execute");
		exit(1);
	}
	save_sysfs(opp,MU_CONF_DIR);
	closelog();
	/* post-call */
	if (opp->end)
		opp->end(opp,POSTCALL);

	final(opp);

	return 0;
}
