/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: init.c,v 1.7 2004/09/12 08:08:06 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<sys/select.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<limits.h>
#include	<stdlib.h>
#include	<sys/time.h>
#include	<errno.h>

#include	<pcmcia/cs_types.h>
#include	<pcmcia/cs.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

/* global */
static int msg_level = MU_MSG_STD;

/*
 * return sum of socket
 */
static int
get_all_socket(int *socket_fd,int *socket_max)
{
	int socket_num,fd_max = 0;
	char socket_file[PATH_MAX];

	for(socket_num = 0;socket_num < *socket_max;socket_num++) {
		sprintf(socket_file,"%s/%s.%d",MU_CONF_DIR,MU_ARG_PCMCIA,socket_num);
		if (access(socket_file,R_OK) == 0)
			unlink(socket_file);
		if (mknod(socket_file, S_IFCHR|S_IREAD|S_IWRITE, makedev(PCMCIA_MAJOR,socket_num)) != 0) {
			LOG(MU_MSG_QUIET,msg_level, "%m");
			return -1;
		}
		socket_fd[socket_num] = open(socket_file,O_RDWR);
		unlink(socket_file);
		if (fd_max < socket_fd[socket_num])	/* verbose */
			fd_max = socket_fd[socket_num];
		else if (socket_fd[socket_num] == -1) {
			if ((errno != ENODEV) && (errno != ENOENT))
				LOG(MU_MSG_QUIET,msg_level,"open error socket_file: %m");
			break;
		}
	}
	*socket_max = fd_max;

	return socket_num;
}

/* cold plug */
static void
call_hotplug(int *socket_fd,int socket_sum,int fd_max)
{
	int i,event;
	char devpath[PATH_MAX];
	fd_set select_fd;
	struct timeval timeout;

	FD_ZERO(&select_fd);
	for (i = 0; i < socket_sum;i++) {
		FD_SET(socket_fd[i], &select_fd);
	}
	timeout.tv_sec = 1;
	timeout.tv_usec = 0;
	while(select(fd_max+1,&select_fd,NULL,NULL,&timeout) < 0)
		;

	for (i = 0; i < socket_sum;i++) {
		if (!FD_ISSET(socket_fd[i], &select_fd))
			continue;
		read(socket_fd[i],&event,4);	/* get event info */
		close(socket_fd[i]);
		if (event == CS_EVENT_CARD_INSERTION) {
			/*
			 * making DEVPATH
			 */
			sprintf(devpath,"/class/pcmcia_socket/pcmcia_socket%d",i);
			/* WAIT_ON for EBUSY */
			execute_hotplug_sysfs(devpath,MU_ARG_PCMCIA,WAIT_ON,msg_level);
		}
	}
}

static void
usage(char *cmd)
{
	LOG(MU_MSG_QUIET,msg_level,"%s (start|stop)",cmd);
}

#define	SOCKET_MAX	16

int
main(int argc,char **argv)
{
	int socket_fd[SOCKET_MAX],socket_sum,fd_max;
	char *sysfs_dir;

	sysfs_dir = coldplug_init(MU_INIT_PCMCIA,MU_ARG_PCMCIA,&msg_level);
	if (msg_level == -1)
		exit(0);

	if (argc > 2) {
		usage(argv[0]);
		exit(1);
	}
	/* for select */
	close(0);
	close(1);
	close(2);
	fd_max = SOCKET_MAX;
	if ((socket_sum = get_all_socket(socket_fd,&fd_max)) == -1) {
		LOG(MU_MSG_QUIET,msg_level,"Socket of pcmcia can not be created.");
		exit(1);
	}
	if (argc == 2) {
		if (strcmp(argv[1],"start") == 0) {
			lock_resource(PCMCIA_LOCKFILE);
			adjust_resources(socket_fd[0],RESOURCE_HOLD);
		} else if (strcmp(argv[1],"stop") == 0) {
			unlock_resource(PCMCIA_LOCKFILE);
			adjust_resources(socket_fd[0],RESOURCE_FREE);
		} else {
			usage(argv[0]);
		}
	} else {	/* argc == 1: called by RC script */
		lock_resource(PCMCIA_LOCKFILE);
		adjust_resources(socket_fd[0],RESOURCE_HOLD);
		call_hotplug(socket_fd,socket_sum,fd_max);
	}

	return 0;
}
