/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: print.c,v 3.6 2004/09/12 07:57:01 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<unistd.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

void
print_config(mu_op_t *opp)
{
	MU_usb_config_t *config = opp->config;
	/*
	 * module idVendor idProduct bcdDevice_lo bcdDevice_hi
	 * bDeviceClass bDeviceSubClass bDeviceProtocol
	 * bInterfaceClass bInterfaceSubClass bInterfaceProtocol
	 * driver_info -> 0x00000000
	 */
	config->match_flags = 0;
	/* VENDOR and PRODUCT */
	if (config->product.vendor != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_VENDOR;
	if (config->product.product != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_PRODUCT;
	/*
	 * ignore dev_lo and dev_high Now!
	 */
	/* CLASS , SUBCLASS and PROTOCOL */
	if (config->device.class != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_DEV_CLASS;
	if (config->device.subclass != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_DEV_SUBCLASS;
	if (config->device.protocol != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_DEV_PROTOCOL;
	/* Alternative CLASS... */
	if (config->interface.class != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_INT_CLASS;
	if (config->interface.subclass != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_INT_SUBCLASS;
	if (config->interface.protocol != 0)
		config->match_flags |= USB_DEVICE_ID_MATCH_INT_PROTOCOL;

	LOG_OPP_STD("MODULE 0x%04x 0x%x 0x%x 0 0 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x00000000",
			config->match_flags,
			config->product.vendor,
			config->product.product,

			config->device.class,
			config->device.subclass,
			config->device.protocol,

			config->interface.class,
			config->interface.subclass,
			config->interface.protocol);
}

void
inform_config(mu_op_t *opp)
{
	MU_usb_config_t *config = opp->config;

	LOG(MU_MSG_STD,opp->msg_level,"vendor:0x%x product:0x%x Dclass:0x%x Dsubclass:0x%x Dprotocol:0x%x Iclass:0x%x Isubclass:0x%x Iprotocol:0x%x",
			config->product.vendor,
			config->product.product,

			config->device.class,
			config->device.subclass,
			config->device.protocol,

			config->interface.class,
			config->interface.subclass,
			config->interface.protocol);
}
