//driver.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "muroard.h"

#ifndef MUROAR_FEATURE_DRIVER
#define MUROAR_FEATURE_DRIVER DRIVER_NONE
#endif

#if   MUROAR_FEATURE_DRIVER == DRIVER_NONE
/* use dummy driver from below */
#elif MUROAR_FEATURE_DRIVER == DRIVER_MUROAR
#include "driver_muroar.c"
#elif MUROAR_FEATURE_DRIVER == DRIVER_LIBAO
#include "driver_ao.c"
#elif MUROAR_FEATURE_DRIVER == DRIVER_OSS
#include "driver_oss.c"
#elif MUROAR_FEATURE_DRIVER == DRIVER_WMM
#include "driver_wmm.c"
#elif MUROAR_FEATURE_DRIVER == DRIVER_ESD
#include "driver_esd.c"
#elif MUROAR_FEATURE_DRIVER == DRIVER_SNDIO
#include "driver_sndio.c"
#else
#error Invalid driver setting. check MUROAR_FEATURE_DRIVER
#endif

#ifndef DRIVER_HAVE_INIT
int driver_init(char * dev) {
 return 0;
}
#endif

#ifndef DRIVER_HAVE_FREE
int driver_free(void) {
#ifdef DRIVER_USE_SYSIO
 if ( DRIVER_SYSIO_FH != -1 )
  return close(DRIVER_SYSIO_FH);
#endif
 return 0;
}
#endif

#ifndef DRIVER_HAVE_WRITE
int driver_write(int16_t * data) {
#ifdef DRIVER_USE_SYSIO
 if ( write(DRIVER_SYSIO_FH, data, g_abuffer_size) != (ssize_t)g_abuffer_size )
  return -1;
#else
#ifndef __WIN32
 usleep(g_abuffer_size*1000000LLU/(long long unsigned)(g_sa_rate*g_sa_channels*2));
#else
 Sleep(g_abuffer_size*1000LLU/(long long unsigned)(g_sa_rate*g_sa_channels*2));
#endif
#endif
 return 0;
}
#endif

//ll
