//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: editinstrument.cpp,v 1.2 2004/06/01 14:25:49 wschweer Exp $
//
//  (C) Copyright 2003 Werner Schweer (ws@seh.de)
//=========================================================

#include <qlistbox.h>

#include "editinstrument.h"
#include "minstrument.h"

//---------------------------------------------------------
//   EditInstrument
//---------------------------------------------------------

EditInstrument::EditInstrument(QWidget* parent, const char* name, WFlags fl)
   : EditInstrumentBase(parent, name, fl)
      {
      // populate instrument list
      for (iMidiInstrument i = midiInstruments.begin(); i != midiInstruments.end(); ++i)
            instrumentList->insertItem((*i)->iname());
      instrumentList->setSelected(0, true);
      connect(instrumentList, SIGNAL(selectionChanged()), SLOT(instrumentChanged()));
      instrumentChanged();
      }

//---------------------------------------------------------
//   instrumentChanged
//---------------------------------------------------------

void EditInstrument::instrumentChanged()
      {
      QListBoxItem* sel = instrumentList->selectedItem();
      if (sel == 0)
            return;
      QString iname = sel->text();
      printf("instrument changed: %s\n", iname.latin1());
      iMidiInstrument i = midiInstruments.begin();
      for (; i != midiInstruments.end(); ++i) {
            if ((*i)->iname() == iname)
                  break;
            }
//      MidiInstrument* instr = *i;

      // populate patch list

      }

//---------------------------------------------------------
//   fileNew
//---------------------------------------------------------

void EditInstrument::fileNew()
      {

      }

//---------------------------------------------------------
//   fileOpen
//---------------------------------------------------------

void EditInstrument::fileOpen()
      {
      printf("fileOpen\n");
      }

//---------------------------------------------------------
//   fileSave
//---------------------------------------------------------

void EditInstrument::fileSave()
      {

      }

//---------------------------------------------------------
//   fileSaveAs
//---------------------------------------------------------

void EditInstrument::fileSaveAs()
      {

      }

//---------------------------------------------------------
//   fileExit
//---------------------------------------------------------

void EditInstrument::fileExit()
      {

      }

