/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 asyncfile.h  -  Core asynchronous file i/o wrapper

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __ASYNCFILE_H__
#define __ASYNCFILE_H__

#include "rcobject.h"

enum {
	//AFM_NONE = 0,
	AFM_READ       = 0x0001,
	AFM_WRITE      = 0x0002,
	AFM_READWRITE  = 0x0003,
	AFM_CREATEPATH = 0x0004 // only valid with 'write' bit on
};

struct SAFileState {
	// general info
	CString sPath;   // file path
	int     hFile;   // file descriptor
	// size and pos
	long    nSize;   // file size
	long    nPos;    // file position
	// completion info
	int     nErrNo;  // last error
	bool    bEoF;    // feof() result after
	int     nReturn; // last value returned by the operation
};

enum AFRType {
	AFR_NONE    = 0x0000,
	AFR_OPEN    = 0x0001,
	AFR_ATTACH  = 0x0002,
	AFR_SEEK    = 0x0004,
	AFR_PREREAD = 0x0008,
	AFR_READ    = 0x0010,
	AFR_WRITE   = 0x0020,
	AFR_CLOSE   = 0x0040,
	AFR_DETACH  = 0x0080,
	AFR_CUSTOM  = 0x0100,
	AFR_GETBUF  = 0x1000,
	AFR_WAIT    = 0x2000,
	AFR_STOP    = 0x8000
};

class MAFDescriptor;
class MAFRequest;
class MCustomAFRequest;
class MAFBuffer;

class MAFRequest : public MRCObject {
public:
	TSmartPtr<MAFDescriptor> pFileDesc;
	//
	SAFileState file_state;
	// request itself
	int type;
	//
	DWORD seqID;
	// open parameters
	int   mode;
	// attach
	int hAttachFile;
	// write/read/pre-read
	TSmartPtr<MAFBuffer> pBuffer;
	int   size;
	// seek
	long offset;
	long whence;
	// custom request
	TSmartPtr<MCustomAFRequest> pCustomRequest;
};

////////////////////////////////////////////////////////////////

class MAsyncFile {
	friend class MAFDescriptor;
	friend class MAFDelayed;
	friend class MAFThread;
public:
	MAsyncFile(int mode);
	virtual ~MAsyncFile();
	
	static void WaitForThreadsStop();
	static void InitStaticStructures(); // MUST be called before the first use!!!
	
	// delayed diagnostics
	//bool IsInProgress();
	//bool IsReady();
	//
	virtual void OnSuccess(DWORD dwSeqReqID, int nReqType, const SAFileState& FileState);
	virtual void OnError(DWORD dwSeqReqID, int nReqType, const SAFileState& FileState);
	virtual void OnSuccessDelayed(DWORD dwSeqReqID, int nReqType, const SAFileState& FileState);
	virtual void OnErrorDelayed(DWORD dwSeqReqID, int nReqType, const SAFileState& FileState);
	// general purpose diagnostics
	int GetLastError();
	// async debug diagnostocs
	DWORD GetCurrRequest(){ return m_dwCurrReq; }
	DWORD GetCurrComplRequest(){ return m_dwCurrCompReq; }
	DWORD GetCurrDelayedComplRequest(){ return m_dwCurrDelayedComplReq; }
	//
	bool Open(LPCSTR szName);
	bool IsOpen();
	//
	bool Attach(int hFile);
	int Detach();
	//
	bool Close();
	bool IsClosed();
	//
	bool Seek(int nOffset, int nWhence);
	int GetPos();
	int GetAsyncPos();
	int GetSize();
	int GetAsyncSize();
	bool EoF();
	//
	int Read(MAFBuffer* pBuff, int nBytes); // return number of bytes read or -1
	// reads data at the specified location
	int ReadSeek(int nOffset, int nWhence, MAFBuffer* pBuff, int nBytes); // return number of bytes read or -1
	//
	int Write(MAFBuffer* pBuff, int nBytes); // return number of bytes written or -1
	// writes data at the specified location
	int WriteSeek(int nOffset, int nWhence, MAFBuffer* pBuff, int nBytes); // return number of bytes written or -1
	//
	bool CustomRequest(MCustomAFRequest* pRequestObject);
	//
	//bool WaitTillReady(); // return false when wait failed
protected:
	TSmartPtr<MAFDescriptor> m_pDesc;
	int   m_nMode;
	DWORD m_dwCurrReq;
	DWORD m_dwCurrCompReq;
	DWORD m_dwCurrDelayedComplReq;
};

class MCustomAFRequest : public MRCObject
{
public:
	virtual bool Do(MAFRequest* pRequest) = 0;
	virtual void Predict(SAFileState& state) = 0;
};

class MRequestDelete : public MCustomAFRequest
{
public:
	MRequestDelete(const CString& path);
	virtual bool Do(MAFRequest* pRequest);
	virtual void Predict(SAFileState& state);
private:
	CString m_path;
	//
	MRequestDelete(); // no implementation
};

class MRequestMove : public MCustomAFRequest
{
public:
	MRequestMove(const CString& pathOld, const CString& pathNew);
	virtual bool Do(MAFRequest* pRequest);
	void Predict(SAFileState& state);
private:
	CString m_pathOld;
	CString m_pathNew;
	MRequestMove(); // no implementation
};

class MAFBuffer : public MRCObject
{
public:
	MAFBuffer(){}
	//
	virtual char* buffer() = 0;
	virtual int   volume() = 0;
protected:
	virtual ~MAFBuffer(){}
};


class MAFBufferTrivial : public MAFBuffer
{
public:
	MAFBufferTrivial(int nBufferSize = 16384){
		m_pBuffer = new char[nBufferSize];
		ASSERT(m_pBuffer);
		m_nSize = nBufferSize;
	}
	virtual char* buffer(){return m_pBuffer;}
	virtual int   volume(){return m_nSize;}
protected:
	char * m_pBuffer;
	int    m_nSize;
	virtual ~MAFBufferTrivial(){
		delete [] m_pBuffer;
	}
};

#endif //__ASYNCFILE_H__

