/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 byteorder.cpp  -  Bit/Byte order management class definition
                             -------------------
    begin                : Thu Jun 8 2000
    copyright            : (C) 2000 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/
 
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include "byteorder.h"

byteOrderTest MByteOrderTest::ms_ByteOrderTest = {1};

void BitReorder(unsigned char* pBuffer, int nSize, int nElementSize, bool bBits, bool bBytes)
{
	if (bBits|bBytes)
	{
		unsigned char* pCurr = NULL;
		unsigned char bt;
		int a,b;			
		for (long n = 0; n<nSize;n+=nElementSize)
		{
			pCurr = ((unsigned char*)pBuffer)+n;
			if (bBytes)
			{
				for (a = 0;a<nElementSize>>1;++a)
				{
					bt = pCurr[a];
					pCurr[a] = pCurr[nElementSize-a-1];
					pCurr[nElementSize-a-1] = bt;
				}
			}
			if (bBits)
			{
				for (a = 0; a<nElementSize; ++a)
				{
					bt = pCurr[a];
					pCurr[a] = 0;
					for (b = 0; b<8; ++b)
					{
						pCurr[a]<<=1;
						if (bt&1)
						pCurr[a] |= 1;
						bt>>=1;
					}
				}
			}
		}
	}		
}

