/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnusock.h  -  Socket handler for the Gnutella network protocol
 
 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)
 
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUSOCK_H_INCLUDED__)
#define __GNUSOCK_H_INCLUDED__

class MGnuDirector;
class MGnuPreferences;

class MGnuSock : public MAsyncSocket
{
public:
	MGnuSock(MGnuDirector*);
	virtual ~MGnuSock();

	void OnTimer();

	int   m_nSecsAlive;
	bool  m_bDestroy;

	public:
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);
	
protected:
	void ForceDisconnect();
	void ParseHandshake(char* pBuffRest, DWORD dwRestSize);
	//
	MGnuPreferences* m_pPrefs;
	MGnuDirector*  m_pDirector;
	
	CString m_sHandshake; // cache for HTTP request or gnutella connection request
	DWORD   m_dwBytesReceived;
protected:
	MGnuSock();                      // no implementation
	MGnuSock(const MGnuSock& rSrc);  // no implementation
};

/////////////////////////////////////////////////////////////////////////////

#endif // __GNUSOCK_H_INCLUDED__

