/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 main.cpp  -  The main() application method which launches the application.
 
    begin                : Sun May 27 10:03:25 CEST 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "mutella.h"
#include "structures.h"
#include "controller.h"
#include "mui.h"
#include "common.h"
#include "asyncfile.h"

//#include <stdio.h>
//#include <stdlib.h>

//#include <pthread.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>


#if __GLIBC__ == 2 && __GLIBC_MINOR__ >= 1
#define HAVE_BACKTRACE
#endif

#ifdef HAVE_BACKTRACE
#include <execinfo.h>
#endif

extern "C" {

#define MAX_BACKTRACE 128
static void * segv_backtrace[MAX_BACKTRACE];

/* disabled in this release by MZ */
#if 0

/***
 * Do not to use malloc() here, or to call a function
 * that uses it, since we've to assume that the heap is
 * possibly damaged.
 */
void libpublic_segv_handler(int signum)
{
    int bsize, i;
    struct stat stat_buf;
    int have_addr2line = stat("/usr/bin/addr2line", &stat_buf) == 0;
    FILE *pa = NULL;

    bsize = backtrace(segv_backtrace, MAX_BACKTRACE);

    fprintf(stderr, "SEGFAULT\n");
    fprintf(stderr, "Backtrace:\n");

    /* Issue an addr2line call (ask if it knows of the addresses by investigating
     * the static image (debug info). This works for debug builds only.
     */
    if (have_addr2line) {
        size_t call_size = 128 + 15 * bsize;
        char * call = (char*) alloca(call_size);
        unsigned int n = 0;
        n += snprintf(call, call_size, "/usr/bin/addr2line --functions --exe=/proc/%d/exe",
                                        getpid());
        for(i = 0; i < bsize; i++) {
            n += snprintf(call + n, call_size - n, " %p", segv_backtrace[i]);
        }
        pa = popen(call, "r");
    }

    for(i = 0; i < bsize; i++) {
        //Dl_info dl_info;
        //int dl_status;
        int a2l_status = 0;
        int a2f_status = 0;
        char a2l_line[127] = {0, };
        char a2l_func[127] = {0, };
        char dl_buf[256];

        /* Ask the dynamic linker if he knows of the address.
         * This works in both release and debug builds
         */
        //dl_status = dladdr(segv_backtrace[i], &dl_info);

        /* Then interpred the addr2line output */
        if (have_addr2line && pa != NULL) {
            int c = 0;
            unsigned int k;
            a2f_status = 1;
            for (k = 0; k < sizeof(a2l_func); k++) {
                c = fgetc(pa);
                if (c < 0 || c == '\n') {
                    a2l_func[k] = 0;
                    break;
                }
                a2l_func[k] = c;
            }
            if (c >= 0) {
                a2l_status = 1;
                for (k = 0; k < sizeof(a2l_line); k++) {
                     c = fgetc(pa);
                     if (c < 0 || c == '\n') {
                         a2l_line[k] = 0;
                         break;
                     }
                     a2l_line[k] = c;
                 }
            }
            if (strncmp(a2l_func, "??", 2) == 0) {
                a2f_status = 0;
            }
            if (strncmp(a2l_line, "??", 2) == 0) {
                a2l_status = 0;
            }
        }
        /*if (dl_status) {
            char buf[20];

            if (segv_backtrace[i] >= (void *) dl_info.dli_saddr) {
                sprintf (buf, "+%#lx",
                         (unsigned long)(segv_backtrace[i] - dl_info.dli_saddr));
            } else {
                sprintf (buf, "-%#lx",
                        (unsigned long)(dl_info.dli_saddr - segv_backtrace[i]));
            }

            snprintf(dl_buf, sizeof(dl_buf), "%s%s%s%s%s",
                                dl_info.dli_fname ?: "",
                                dl_info.dli_sname ? "(" : "",
                                dl_info.dli_sname ?: "",
                                dl_info.dli_sname ? buf : "",
                                dl_info.dli_sname ? ") " : " ");
        }*/

        /*log_msg(LOG_ERR, "%s%s%s%s%s%s[%p]",
                        a2l_status ? a2l_line : "",
                        a2f_status ? "(" : "",
                        a2f_status ? a2l_func : "",
                        a2f_status ? ")" : "",
                        (a2l_status || a2f_status) && dl_status ? ", " : " ",
                        dl_status ? dl_buf : "",
                        segv_backtrace[i]);*/
        fprintf(stderr, "%s%s%s%s[%p]\n",
                        a2l_status ? a2l_line : "",
                        a2f_status ? "(" : "",
                        a2f_status ? a2l_func : "",
                        a2f_status ? ")" : "",
                        segv_backtrace[i]);
    }
    pclose(pa);
    fprintf(stderr, "End of backtrace.\n");

    /* reraise the segv signal */
    struct sigaction sa;
    sa.sa_handler = SIG_DFL;
    sigemptyset (&sa.sa_mask);
    sa.sa_flags = 0;
    sigaction (signum, &sa, NULL);
    raise(signum);
}

void mutella_handle_sigsegv(int s)
{
  if (s != SIGSEGV)
  {
    fprintf(stderr, "Unknown signal.\n");
    return;
  }

  fprintf(stderr, "Mutella Segmentation Violation Detected.\n");
  /*fprintf(stderr, "Fault Address: [0x%08lX]\n", (unsigned long)si->si_addr); */

#ifdef HAVE_BACKTRACE
  fprintf(stderr, "Backtrace:\n");
  {
    void *array[32];
    unsigned short i;
    int n = backtrace(array, 32);
    char **res = backtrace_symbols(array, n);
    for (i = 0; i < n; i++)
      fprintf(stderr, "  %s\n", res[i]);
  }
  fprintf(stderr, "Attempting to generate core file.\n");
  pthread_kill_other_threads_np();
#endif
  abort();
}

void mutella_handle_sigchld(int s)
{
  if (s != SIGCHLD)
  {
    fprintf(stderr, "Unknown signal.\n");
    return;
  }

  wait(NULL);
}

#endif //0

} /*extern "C"*/

MMutex g_LibcMutex;
//MMutex g_GetHostByNameMutex;

// The program starts here
int main(int argc, char *argv[])
{
    // set ignore to the alarm clock
    struct sigaction sa;
    memset(&sa,0,sizeof(sa));
    sa.sa_handler=SIG_IGN;
    sa.sa_flags=SA_RESTART;
    VERIFY(0==sigaction(SIGALRM, &sa, NULL));
    memset(&sa,0,sizeof(sa));
    sa.sa_handler=SIG_IGN;
    sa.sa_flags=SA_RESTART;
    // quick hack to workaround 'crashes' on send
    VERIFY(0==sigaction(SIGPIPE, &sa, NULL));
    //
    //signal(SIGSEGV, &mutella_handle_sigsegv);
    //signal(SIGCHLD, &mutella_handle_sigchld);
    //signal(SIGSEGV, &libpublic_segv_handler);
    //
    // set the random seed to start with
    srand(xtime());
    //
    // Initialise static data structures in various classes
    MAsyncFile::InitStaticStructures();
    //
    MController controller;
	if (!controller.Init())
		return EXIT_FAILURE;

	// start the controller functionality
    controller.Do();

	return EXIT_SUCCESS;
}

