# #########################################################
#
# NAME:         
#       util.pro
#
# PURPOSE:
#       Use qt qmake on this to make the Makefile.
#
# DESCRIPTION:
#       This file is really only for XP because UNIX, 
#       Linux, and OSX can use the gnu automake.
#
#       This file exists for those that have qt (such as
#       myself). Others may simply use the Makefile as is.
#
#       The idea is that we create a static lib which can
#       be used, in-place, by the setup library and the
#       driver.
#
#       Util does not include any Qt but Qt based code 
#       in MyODBC does depend upon Util.
#
# #########################################################

# #########################################################
# COMMON
# #########################################################

TEMPLATE                = lib
TARGET                  = myodbcutil
DESTDIR                 = ./
OBJECTS_DIR             = .tmp
CONFIG                  += staticlib thread console

# #########################################################
# WIN
# #########################################################
win32:DEFINES           -= UNICODE
win32:DEFINES           += WIN32 HAVE_SQLGETPRIVATEPROFILESTRING HAVE_ODBCINST_H
win32:LIBS              += odbc32.lib odbccp32.lib

# #########################################################
# UNIX
# #########################################################
unix:LIBS               += -L/usr/lib -lodbc -lodbcinst
unix:DEFINES            += HAVE_SQLGETPRIVATEPROFILESTRING HAVE_ODBCINST_H

# #########################################################
# OSX
# #########################################################
mac:CONFIG		-= thread
mac:LIBS		-= -lodbc -lodbcinst
mac:LIBS		+= -liodbc -liodbcinst

# #########################################################
# FILES
# #########################################################
HEADERS			= \
                        MYODBCUtil.h                     
SOURCES			= \
                        MYODBCUtilAllocDataSource.c \
                        MYODBCUtilAllocDriver.c \          
                        MYODBCUtilClearDataSource.c \
                        MYODBCUtilClearDriver.c \          
                        MYODBCUtilDefaultDataSource.c \          
                        MYODBCUtilDSNExists.c \
                        MYODBCUtilFreeDataSource.c \       
                        MYODBCUtilFreeDriver.c \
                        MYODBCUtilGetDataSourceNames.c \
                        MYODBCUtilGetDriverNames.c \
                        MYODBCUtilInsertStr.c \            
                        MYODBCUtilReadConnectStr.c \
                        MYODBCUtilReadDataSource.c \       
                        MYODBCUtilReadDataSourceStr.c \
                        MYODBCUtilReadDriver.c \           
                        MYODBCUtilWriteConnectStr.c \
                        MYODBCUtilWriteDataSource.c \      
                        MYODBCUtilWriteDataSourceStr.c \
                        MYODBCUtilWriteDriver.c

