/* MAServerLogView */

#import <Cocoa/Cocoa.h>
#include "myx_admin_public_interface.h"

typedef MYX_LOGFILE* (*MALogParserFunction)(const char*, int, int, int*);


@interface MAServerLogView : NSObject
{
    IBOutlet NSTableView *indexTable;
    IBOutlet NSSlider *pageSlider;
    IBOutlet NSTextField *pathText;
    IBOutlet NSTextField *sizeText;
    IBOutlet NSTextView *text;
    IBOutlet id topView;
    
    NSString *_path;
    MYX_LOGFILE *_log;
    int *_lineIndex;
    
    MALogParserFunction _func;
}
- (IBAction)changePage:(id)sender;
- (IBAction)saveLog:(id)sender;
- (IBAction)selectLog:(id)sender;

- (id)initWithPath:(NSString*)path
     parseFunction:(MALogParserFunction)func;
- (NSView*)topView;

@end