unit AdminSectionsList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls,
  Sections, InstanceSections, ApplicationDataModule;

type
  TAdminSectionsListForm = class(TInstanceSectionForm)
    AdminSectionsListPnl: TTntPanel;
    AdminSectionsListView: TTntListView;

    constructor Create(AOwner: TComponent; SidebarSection: TSidebarSectionType); reintroduce; overload;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure AdminSectionsListViewDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AdminSectionsListForm: TAdminSectionsListForm;

implementation

uses Main, InstanceDataModule;

{$R *.dfm}

constructor TAdminSectionsListForm.Create(AOwner: TComponent; SidebarSection: TSidebarSectionType);
var theListItem: TListItem;
begin
  inherited Create(AOwner, InstanceDM);

  //Add ListView items
  AdminSectionsListView.Items.Clear;

  case SidebarSection of
    SSTAdmin_ServerConfig:
    begin
      theListItem:=AdminSectionsListView.Items.Add;
      theListItem.Caption:='Service Control';
      theListItem.ImageIndex:=3;
      theListItem.SubItems.Text:='Start, stop or restart the MySQL Server.';
      theListItem.Data:=TSidebarSection.Create(SSTAdmin_ServiceControl);

      theListItem:=AdminSectionsListView.Items.Add;
      theListItem.Caption:='User Administration';
      theListItem.ImageIndex:=5;
      theListItem.SubItems.Text:='Create new database users and manage existing user accounts.';
      theListItem.Data:=TSidebarSection.Create(SSTAdmin_UserAdministration);

      theListItem:=AdminSectionsListView.Items.Add;
      theListItem.Caption:='Backup';
      theListItem.ImageIndex:=7;
      theListItem.SubItems.Text:='Create backups of the MySQL databases.';
      theListItem.Data:=TSidebarSection.Create(SSTAdmin_Backup);

      theListItem:=AdminSectionsListView.Items.Add;
      theListItem.Caption:='Replication';
      theListItem.ImageIndex:=8;
      theListItem.SubItems.Text:='Setup and manage Master - Slave replications setups.';
      theListItem.Data:=TSidebarSection.Create(SSTAdmin_Replication);
    end;
  end;
end;

procedure TAdminSectionsListForm.FormCreate(Sender: TObject);
begin
  DockedPanel:=AdminSectionsListPnl;
  AdminSectionsListView.SmallImages:=ApplicationDM.AdminTree24ImageList;
end;

procedure TAdminSectionsListForm.FormDestroy(Sender: TObject);
begin
  //
end;

procedure TAdminSectionsListForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //
end;

procedure TAdminSectionsListForm.AdminSectionsListViewDblClick(
  Sender: TObject);
begin
  if(Assigned(AdminSectionsListView.Selected))then
    if(Assigned(AdminSectionsListView.Selected.Data))then
      TMainForm(AdminSectionsListPnl.Parent.Parent).ShowSidebarSection(TSidebarSection(AdminSectionsListView.Selected.Data));
end;

end.
