//
//  MDialogs.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Sat Jul 10 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MDialogs.h"

@implementation MStringRequestSheet

+ (MStringRequestSheet*)sheetWithMessage:(NSString*)message
{
  return [[[MStringRequestSheet alloc] initWithMessage:message] autorelease];
}


- (id)initWithMessage:(NSString*)message
{
  NSRect contentRect;
  
  contentRect= NSMakeRect(0.0, 0.0, 420.0, 138.0);
  
  self= [super initWithContentRect:contentRect 
                         styleMask:NSBorderlessWindowMask
                           backing:NSBackingStoreBuffered 
                             defer:YES];
  if (self)
  {
    id w;
    NSView *contentView= [[NSView alloc] initWithFrame:contentRect];
    [self setContentView:contentView];
    [contentView release];
    [self setHasShadow:YES];
    
    w= [[NSTextField alloc] initWithFrame:NSMakeRect(17.0, 90.0, 377.0, 28.0)];
    [w setStringValue:message];
    [contentView addSubview:w];
    [w release];
    [w setAlignment:NSCenterTextAlignment];
    [w setEditable:NO];
    [w setDrawsBackground:NO];
    [w setBordered:NO];
    
    text= [[NSTextField alloc] initWithFrame:NSMakeRect(77.0, 60.0, 264.0, 22.0)];
    [contentView addSubview:text];
    [text setEditable:YES];
    [text setEnabled:YES];
    [text setDrawsBackground:YES];
    [self setInitialFirstResponder: text];
 
    w= [[NSButton alloc] initWithFrame:NSMakeRect(316.0, 11.0, 90.0, 32.0)];
    [contentView addSubview:w];
    [w setTitle:@"OK"];
    [w release];
    [w setAction:@selector(ok:)];
    [w setTarget:self];
    [[w cell] setBezelStyle:NSRoundedBezelStyle];
    [self setDefaultButtonCell:[w cell]];
    
    w= [[NSButton alloc] initWithFrame:NSMakeRect(224.0, 11.0, 90.0, 32.0)];
    [contentView addSubview:w];
    [w setTitle:@"Cancel"];
    [w release];
    [w setAction:@selector(cancel:)];
    [w setTarget:self];
    [[w cell] setBezelStyle:NSRoundedBezelStyle];
  }
  return self;
}


- (void)cancel:(id)sender
{
  [NSApp endSheet:self];
  canceled= YES;
}

- (void)ok:(id)sender
{
  [NSApp endSheet:self];
  canceled= NO;
}

- (void)dealloc
{
  [text release];
  [super dealloc];
}

- (void)sheetDidEnd:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
  [NSApp abortModal];
  [sheet orderOut:self];
}

- (BOOL)acceptsFirstResponder
{
  return YES;
}

- (NSString*)runModal:(NSWindow*)window
{
/*  [NSApp beginSheet:self
     modalForWindow:window
      modalDelegate:self
     didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
        contextInfo:self];
*/
  [self makeKeyAndOrderFront:self];
    [self center];
  [NSApp runModalForWindow:self];

  if (canceled)
    return nil;
  else
    return [text stringValue];
}



@end
