package com.mysql.grt;

public class GrtObject implements GrtXml {

	protected GrtObjectData data = null;

	protected GrtObject() {
	}

	public GrtObject(Object obj) {
		if ((obj == null) || (obj instanceof com.mysql.grt.GrtObject)) {
			data = new GrtObjectDataLocal(this);
			data.setOwner((GrtObject) obj);
			Grt.getInstance().addToObjectCache(this);
		} else if (obj instanceof String) {
			data = new GrtObjectDataGlobal((String) obj);
		}
	}

	public String getName() {
		return data.getName();
	}

	public String setName(String name) {
		return data.setName(name);
	}

	public String get_id() {
		return data.get_id();
	}

	public String set_id(String _id) {
		return data.set_id(_id);
	}

	public GrtObject getOwner() {
		return data.getOwner();
	}

	public GrtObject setOwner(GrtObject owner) {
		return data.setOwner(owner);
	}

	public String getOwnerById() {
		return data.getOwnerById();
	}

	public void setOwnerById(String owner_id) {
		data.setOwnerById(owner_id);
	}

	public String getGrtXml() {
		return getGrtXml("");
	}

	public String getGrtXml(String keyTag) {
		String xml = "<value type=\"dict\" struct-name=\""
				+ this.getClass().getName().substring(14) + "\"" + keyTag;

		if (data instanceof GrtObjectDataLocal)
			xml += ">\n" + getGrtXmlMembers() + "</value>\n";
		else
			xml += " global-object-path=\""
				+ Grt.escapeStringForXml(((GrtObjectDataGlobal) data).getGlobalObjectPath()) + "\" />\n";

		return xml;
	}

	public String getGrtXmlMembers() {
		String xml = "<value type=\"string\" key=\"_id\">"
				+ Grt.escapeStringForXml(get_id()) + "</value>\n";

		if (getName() != null)
			xml += "<value type=\"string\" key=\"name\">"
					+ Grt.escapeStringForXml(getName()) + "</value>\n";

		if (getOwner() != null)
			xml += "<value type=\"string\" key=\"owner\">"
					+ Grt.escapeStringForXml(getOwner().get_id())
					+ "</value>\n";

		return xml;
	}
}