/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.SCRAMMD5;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class Authentication {
    private byte[] salt;
    private byte[] clientchallenge = new byte[64];
    private byte[] serverchallenge;
    private int maxpasswordLen = 0;

    public Authentication() throws NoSuchAlgorithmException {
        int n = 10;
        while (true) {
            try {
                SecureRandom.getInstance("SHA1PRNG").nextBytes(this.getClientchallenge());
                return;
            }
            catch (Exception exception) {
                if (--n > 0) continue;
                throw new NoSuchAlgorithmException(exception.toString());
            }
            break;
        }
    }

    public byte[] getClientchallenge() {
        return this.clientchallenge;
    }

    public byte[] getClientProof(byte[] byArray) throws SQLExceptionSapDB {
        try {
            return SCRAMMD5.scrammMD5(this.salt, byArray, this.clientchallenge, this.serverchallenge);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", "NoSuchAlgorithmException - algorithm \"MD5\" not supported by the java vm"));
        }
    }

    public void parseServerChallenge(DataPartVariable dataPartVariable) throws SQLExceptionSapDB {
        if (!dataPartVariable.nextRow() || !dataPartVariable.nextField()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
        }
        String string = dataPartVariable.getString(dataPartVariable.getCurrentOffset(), dataPartVariable.getCurrentFieldLen());
        if (!string.equals("SCRAMMD5")) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
        }
        if (!dataPartVariable.nextField() || dataPartVariable.getCurrentFieldLen() < 8) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
        }
        if (dataPartVariable.getCurrentFieldLen() == 40) {
            this.salt = dataPartVariable.getBytes(dataPartVariable.getCurrentOffset(), 8);
            this.serverchallenge = dataPartVariable.getBytes(dataPartVariable.getCurrentOffset() + 8, dataPartVariable.getCurrentFieldLen() - 8);
        } else {
            DataPartVariable dataPartVariable2 = new DataPartVariable((StructuredMem)new StructuredBytes(dataPartVariable.getBytes(dataPartVariable.getCurrentOffset(), dataPartVariable.getCurrentFieldLen())), 1);
            if (!dataPartVariable2.nextRow() || !dataPartVariable2.nextField()) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
            }
            this.salt = dataPartVariable2.getBytes(dataPartVariable2.getCurrentOffset(), dataPartVariable2.getCurrentFieldLen());
            if (!dataPartVariable2.nextField()) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
            }
            this.serverchallenge = dataPartVariable2.getBytes(dataPartVariable2.getCurrentOffset(), dataPartVariable2.getCurrentFieldLen());
            if (dataPartVariable.nextField()) {
                DataPartVariable dataPartVariable3 = new DataPartVariable((StructuredMem)new StructuredBytes(dataPartVariable.getBytes(dataPartVariable.getCurrentOffset(), dataPartVariable.getCurrentFieldLen())), 1);
                if (!dataPartVariable3.nextRow() || !dataPartVariable3.nextField()) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
                }
                do {
                    if (dataPartVariable3.getString(dataPartVariable3.getCurrentOffset(), dataPartVariable3.getCurrentFieldLen()).equals("maxpasswordlen")) {
                        if (!dataPartVariable3.nextField()) {
                            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
                        }
                        try {
                            this.maxpasswordLen = Integer.parseInt(dataPartVariable3.getString(dataPartVariable3.getCurrentOffset(), dataPartVariable3.getCurrentFieldLen()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
                        }
                    } else {
                        if (dataPartVariable3.nextField()) continue;
                        throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.wrongserverchallengereceived", Tracer.Hex2String(dataPartVariable.getBytes(0, dataPartVariable.size()))));
                    }
                } while (dataPartVariable3.nextField());
            }
        }
    }

    public int getMaxpasswordLen() {
        return this.maxpasswordLen;
    }
}

