REM CommandInterpreter: $(COMSPEC)
@echo off

rem ------------------------------
rem create directories

echo Create runtime image directories ...
if not exist ..\..\temp mkdir ..\..\temp

if not exist ..\bin mkdir ..\bin
if not exist ..\bin\windows mkdir ..\bin\windows
if not exist ..\bin\windows\xml mkdir ..\bin\windows\xml
if not exist ..\bin\windows\locale mkdir ..\bin\windows\locale
echo .

rem ------------------------------
rem copy appropriate licence

echo Copying licence files ...
if exist ..\bin\windows\COPYING del ..\bin\windows\COPYING
if exist ..\bin\windows\MySQLEULA.txt del ..\bin\windows\MySQLEULA.txt

copy ..\..\mysql-gui-common\res\COPYING ..\bin\windows\COPYING
echo .

rem ------------------------------
rem copy dlls

echo Copying MySQL Client library
copy ..\..\mysql-gui-win-res\lib\mysql\libmysql.dll ..\bin\windows\libmysql.dll
echo .

echo Copying glib-2.0 libraries
copy ..\..\mysql-gui-win-res\lib\glib-2.0\intl.dll ..\bin\windows\intl.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libglib-2.0-0.dll ..\bin\windows\libglib-2.0-0.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libgmodule-2.0-0.dll ..\bin\windows\libgmodule-2.0-0.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libgobject-2.0-0.dll ..\bin\windows\libgobject-2.0-0.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libgthread-2.0-0.dll ..\bin\windows\libgthread-2.0-0.dll
echo .

echo Copying libxml2 libraries
copy ..\..\mysql-gui-win-res\lib\libxml\iconv.dll ..\bin\windows\iconv.dll
copy ..\..\mysql-gui-win-res\lib\libxml\libxml2.dll ..\bin\windows\libxml2.dll
copy ..\..\mysql-gui-win-res\lib\libxml\zlib.dll ..\bin\windows\zlib.dll
echo .

rem ------------------------------
rem copy xml files

echo Copying XML files
copy ..\..\mysql-gui-common\res\mysqlx_dbm_charsets.xml ..\bin\windows\xml\mysqlx_dbm_charsets.xml
copy ..\..\mysql-gui-common\res\mysqlx_dbm_datatypes.xml ..\bin\windows\xml\mysqlx_dbm_datatypes.xml

copy ..\res\mysqladmin_health.xml ..\bin\windows\xml\mysqladmin_health.xml
copy ..\res\mysqladmin_startup_variables_description.dtd ..\bin\windows\xml\mysqladmin_startup_variables_description.dtd
copy ..\res\mysqladmin_startup_variables_description.xml ..\bin\windows\xml\mysqladmin_startup_variables_description.xml
copy ..\res\mysqladmin_status_variables.xml ..\bin\windows\xml\mysqladmin_status_variables.xml
copy ..\res\mysqladmin_system_variables.xml ..\bin\windows\xml\mysqladmin_system_variables.xml

copy ..\res\mysqlx_translations_administrator.xml ..\bin\windows\xml\mysqlx_translations_administrator.xml
copy ..\res\mysqlx_translations_general.xml ..\bin\windows\xml\mysqlx_translations_general.xml
echo .

rem ------------------------------
rem copy fonts

rem ------------------------------
rem copy translations

echo Copying translations files
copy ..\res\MakeMo.bat ..\bin\windows\locale\.
copy ..\..\mysql-gui-common\res\how_to_translate.txt ..\bin\windows\locale\.
copy ..\..\mysql-gui-common\res\languages_list.txt ..\bin\windows\locale\.

call ..\make_translations.cmd
echo .
