
run_test()
{
  name_test_file=$1
  format=$2
  name_result=$3

  cp $name_test_file ./in.xml
  ./test_xml $format
  rm ./in.xml
  rm -f $name_result
  mv out.xml $name_result
}

check()
{
  format=$1
  test_name=$2
  test_prompt=$3

  name_found="${format}_${test_name}"
  name_test_file="./t/${name_found}.test.xml"
  name_prefix="./r/${name_found}"
  name_result="${name_prefix}.result.xml"
  name_etalon="${name_prefix}.result.etalon.xml"
  name_diff="${name_prefix}.result.diff"

  run_test $name_test_file $format $name_result

  compare_results $name_etalon $name_result $name_diff
  fc_result=$?
  print_test_res "$test_prompt" $fc_result
}

check_idempotency()
{
  format=$1
  test_name=$2
  test_prompt=$3

  name_found="${format}_${test_name}"
  name_prefix="./r/${name_found}"
  name_test_file="${name_prefix}.result.etalon.xml"
  name_result="${name_prefix}.id.result.xml"
  name_etalon="${name_prefix}.result.etalon.xml"
  name_diff="${name_prefix}.id.result.diff"

  run_test $name_test_file $format $name_result

  compare_results $name_etalon $name_result $name_diff
  fc_result=$?
  print_test_res "$test_prompt" $fc_result
}

print_title "test xml storing"

check             backup_profile simple  "backup_profile simple read write"
check_idempotency backup_profile simple  "backup_profile simple read write idempotency"

check             backup_profile example "Ulli's test backup_profile simple read write"
check_idempotency backup_profile example "Ulli's test backup_profile simple read write idempotency"

print_footer
exit $one_of_tests_failed
