#include "option.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qmessagebox.h>

void Option::signal_connect()
{
	connect((const QObject *)fire, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_fire()));
	connect((const QObject *)close, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_close()));
	connect((const QObject *)apply, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_apply()));
	connect((const QObject *)button, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_xpm()));
}

void Option::slot_flag(struct __option__ *option)
{
	this->option = option;

	xpm->setText(option->xpm);
	schema->setChecked(option->schema);
	password->setChecked(option->password);
	exit->setChecked(option->exit);
	from->lineEdit()->setText(QString::number(option->from));
	to->lineEdit()->setText(QString::number(option->to));
	query->setChecked(!option->clear);
	save->setChecked(option->save);
	log->setChecked(option->log);
}
