#include "loglistview.h"
#include <qpopupmenu.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qcursor.h>

LogListView::LogListView(QWidget *parent)
: QListView(parent)
{
	addColumn("#");
	addColumn("Time");
	addColumn("User");
	addColumn("Query");
	addColumn("Error");

	connect(this, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )), this, SLOT(slot_click(QListViewItem *, const QPoint &, int)));
}

LogListView::~LogListView()
{
}

void LogListView::slot_click(QListViewItem *s, const QPoint &, int)
{
	QPopupMenu *z = new QPopupMenu();

	z->insertItem(tr("Cl&ear"), this, SLOT(slot_clear()));
	z->insertItem(tr("&Save"), this, SLOT(slot_save()));

	z->popup(QCursor::pos());
}

void LogListView::slot_clear()
{
	clear();
}

void LogListView::slot_save()
{
	QString s = QFileDialog::getSaveFileName("", "*.log", this);
	if(s.isEmpty()) 
		return;
    
	if(QFile::exists(s))
	{
		int z = QMessageBox::warning (this, tr("MySQL Navigator"), tr("File already exists.\nDo you want to overwrite it?"), tr("Yes"), tr("No"));
		
		if(z == 1)
		{
			return;
		}
	}

	QFile log(s);

	if(log.open(IO_WriteOnly) == FALSE)
		return;
	
	QListViewItemIterator z(this);

	QString value;

	for(; z.current(); ++z)
	{
		for(int s = 0; s < columns(); s++)
			value += z.current()->text(s).local8Bit() + " ";
	
		value = value.stripWhiteSpace();
		value += "\n";
	}

	log.writeBlock(value.latin1(), value.length());

	log.close();
}
