//
//  MMySQLWorker.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Tue Jun 22 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MMySQLWorker.h"
#import "MPtrArray.h"

@implementation MMySQLWorker

+ (void)connectWithPorts:(NSArray *)portArray
{
  NSAutoreleasePool *pool;
  NSConnection *connection;
  MMySQLWorker *me;

  pool = [[NSAutoreleasePool alloc] init];
  // connect back to the controller
  connection = [NSConnection connectionWithReceivePort: [portArray objectAtIndex:0]
                                              sendPort: [portArray objectAtIndex:1]];
  me = [[self alloc] init];
  [connection setRootObject: me];
  [me release];
  // enter the run loop, waiting for requests
  [[NSRunLoop currentRunLoop] run];

  [pool release];
  [NSThread exit];
}


- (id)init
{
  return self;
}


- (void)setManager: (MWorkerManager*)manager
               tag: (int)tag
{
  _manager= [manager retain];
  _tag= tag;
}


- (int)tag
{
  return _tag;
}


- (oneway void)performConnectTo: (MDataToken)infoToken
{
  MYSQL *mysql;
  BOOL ok= YES;
  NSDictionary *dict;
  int token;
  MYX_USER_CONNECTION *info= [[[MWorkerManager manager] getData:infoToken] pointerValue];

  mysql= myx_mysql_init();
  
  if (myx_connect_to_instance(info, mysql) < 0)
    ok= NO;
  
  dict= [NSDictionary dictionaryWithObjectsAndKeys: [NSValue valueWithPointer: info], @"info",
    [NSValue valueWithPointer: mysql], @"mysql", nil];
  token= [[MWorkerManager manager] putData: dict];
  [_manager notifyConnection: token];
  [_manager workerFinished: self];
}


- (oneway void)performSelector: (SEL)sel
                        target: (id)anObject
                      argument: (id)argument
                    identifier: (NSString*)identifier
{ 
  int result;

  NSLog(@"worker thread performing %@ (arg class %@)", identifier,
        [argument className]);
  result= [anObject performSelector: sel
                         withObject: argument];
  NSLog(@"performed ok %@", identifier);
  [_manager notifyFinished: identifier
                    result: result];
  [_manager workerFinished: self];
}


- (MDataToken)performCallback1AndWait:(MDataToken)argt
{
  NSLog(@"ENTER");
  {
  MPtrArray *args= [_manager getData:argt];
    NSLog(@"===== %p", [args pointerAtIndex:0]);
  {
  MCallback1 cback= [args pointerAtIndex:0];
  MYSQL *mysql= [args pointerAtIndex:1];
  void *arg= [args pointerAtIndex:2];
  
  NSLog(@"in worker thread");
  
  return [_manager putData: [NSValue valueWithPointer: (*cback)(mysql, arg)]];
  }}
}

@end
