#ifndef _LF_GRTTREEVIEW_H_
#define _LF_GRTTREEVIEW_H_

#include <mforms/mforms.h>
#include "lf_view.h"
#include "linux_utilities/treemodel_wrapper.h"

namespace mforms {
namespace gtk {


class GRTTreeViewImpl : public ViewImpl
{
private:
  struct ColumnSpec
  {
    GRTTreeColumnType type;
    int column;
    int default_width;
    std::string name;
    bool editable;
  };

  Gtk::ScrolledWindow *_swin;
  Gtk::TreeView *_tree;
  ExpandedRowsStorage _expanded_rows;

  Glib::RefPtr<TreeModelWrapper> _store;
  std::vector<ColumnSpec> _columns;

  virtual Gtk::Widget *get_outer() const { return _swin; }
  virtual Gtk::Widget *get_inner() const { return _tree; }


  GRTTreeViewImpl(GRTTreeView *self, TreeOptions options);
  void row_activated(const Gtk::TreeModel::Path &path, Gtk::TreeViewColumn *column, GRTTreeView *tree);
  void selection_changed(GRTTreeView *tree);
  void set_model(bec::TreeModel *model);
  void set_column_width(int model_column, int width);
  int add_column(GRTTreeColumnType type, int model_column, const std::string &name, bool editable);
  void refresh(const bec::NodeId &node);
  static bool create(GRTTreeView *self, mforms::TreeOptions options);
  static void set_model(GRTTreeView *self, bec::TreeModel *model);
  static int add_column(GRTTreeView *self, GRTTreeColumnType type, int model_column, const std::string &name);
  static int add_column_editable(GRTTreeView *self, GRTTreeColumnType type, int model_column, const std::string &name);
  static void refresh(GRTTreeView *self, const bec::NodeId &node);
  static void set_column_width(GRTTreeView *self, int model_column, int width);
  static bool get_selected_node(GRTTreeView *self, bec::NodeId &node);
  static int get_selection(GRTTreeView *self, std::vector<bec::NodeId> &nodes);
  static void set_allow_multi_selection(GRTTreeView *self, bool flag);
  static void row_count_changed(GRTTreeView *self, const bec::NodeId &parent, int old_count);
  static void set_expanded(GRTTreeView *self, const bec::NodeId &node, bool expanded);

public:
  static void init();
};

}
}

#endif
