/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_TOOLBAR_H_
#define _STUB_TOOLBAR_H_

#include "stub_view.h"

namespace mforms {
namespace stub {

class ToolBarImpl : public ViewImpl
{
 protected:
  ToolBarImpl(::mforms::ToolBar *self)
    : ViewImpl(self)

  {
  }

  static bool __stdcall create_tool_bar(ToolBar *item, ToolBarType type)
  {
    return true;
  }


  static void __stdcall insert_item(ToolBar *toolbar, int index, ToolBarItem *item)
  {
  }


  static void __stdcall remove_item(ToolBar *toolbar, ToolBarItem *item)
  {
  }


  static bool __stdcall create_tool_item(ToolBarItem *item, ToolBarItemType type)
  {
    return true;
  }


  static void __stdcall set_item_icon(ToolBarItem *item, const std::string&)
  {
  }


  static void __stdcall set_item_alt_icon(ToolBarItem *item, const std::string&)
  {
  }


  static void __stdcall set_item_text(ToolBarItem *item, const std::string&)
  {
  }


  static std::string __stdcall get_item_text(ToolBarItem *item)
  {
    return "";
  }


  static void __stdcall set_item_enabled(ToolBarItem *item, bool)
  {
  }


  static bool __stdcall get_item_enabled(ToolBarItem *item)
  {
    return true;
  }


  static void __stdcall set_item_checked(ToolBarItem *item, bool)
  {
  }


  static bool __stdcall get_item_checked(ToolBarItem *item)
  {
    return true;
  }


  static void __stdcall set_item_tooltip(ToolBarItem *item, const std::string&)
  {
  }


  static void __stdcall set_selector_items(ToolBarItem* item, const std::vector<std::string>& values)
  {
  }



public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_tool_bar_impl.create_tool_bar = &ToolBarImpl::create_tool_bar;
    f->_tool_bar_impl.create_tool_item = &ToolBarImpl::create_tool_item;
    f->_tool_bar_impl.get_item_checked = &ToolBarImpl::get_item_checked;
    f->_tool_bar_impl.get_item_enabled = &ToolBarImpl::get_item_enabled;
    f->_tool_bar_impl.get_item_text = &ToolBarImpl::get_item_text;
    f->_tool_bar_impl.insert_item = &ToolBarImpl::insert_item;
    f->_tool_bar_impl.remove_item = &ToolBarImpl::remove_item;
    f->_tool_bar_impl.set_item_alt_icon = &ToolBarImpl::set_item_alt_icon;
    f->_tool_bar_impl.set_item_checked = &ToolBarImpl::set_item_checked;
    f->_tool_bar_impl.set_item_enabled = &ToolBarImpl::set_item_enabled;
    f->_tool_bar_impl.set_item_icon = &ToolBarImpl::set_item_icon;
    f->_tool_bar_impl.set_item_text = &ToolBarImpl::set_item_text;
    f->_tool_bar_impl.set_item_tooltip = &ToolBarImpl::set_item_tooltip;
    f->_tool_bar_impl.set_selector_items = &ToolBarImpl::set_selector_items;
  }
};

}
}

#endif
