#
# spec file for mysqlcc
# (c) 2002 MySQL AB
#

%define name	mysqlcc
%define	rel	1
%global	build_mandrake	%([ -e /etc/mandrake-release ]; echo $[1-$?])

Name: 		%{name}
Version: 0.9.4
License:	GPL
Group:		Databases
Summary:	MySQL Control Center
URL:		http://www.mysql.com/products/mysqlcc/
BuildRoot:	%{_tmppath}/%{name}-%{version}-buildroot
BuildRequires:	libqt3-devel libmysql-devel patch
%if %build_mandrake
Source:		%{name}-%{version}-src.tar.bz2
BuildRequires:	ImageMagick
Release:	%{rel}mdk
%define 	prefix	%{_prefix}
%else
Source:		%{name}-%{version}-src.tar.gz
#Patch:		%{name}-%{version}-defaultpath.patch.gz
Release:	%{rel}
%define 	prefix	/usr
%endif

%description
mysqlcc is a platform independent graphical MySQL administration client.
It is based on Trolltech's Qt toolkit.

%prep
%setup -n %{name}-%{version}-src -q
patch -p1 << EOF
--- mysqlcc-0.8.7-src/src/CApplication.cpp.orig	2003-01-12 00:49:00.000000000 +0200
+++ mysqlcc-0.8.7-src/src/CApplication.cpp	2003-01-12 00:49:32.000000000 +0200
@@ -119,8 +119,8 @@
   confirm_critical = strtobool(cfg->readStringEntry("Confirm Critical", "true"));
   
   //Directory where mysqlcc.exe (or mysqlcc) is.
-  QString mydir = QDir::currentDirPath() + "/";
-  //QString mydir = "/usr/share/mysqlcc/";  This needs to be done with a PREFIX define ..
+  //QString mydir = QDir::currentDirPath() + "/";
+  QString mydir = "%{_datadir}/mysqlcc/";  //This needs to be done with a PREFIX define ..
   
   //Translations path
   translations_path = cfg->readStringEntry("Translations Path", mydir + "translations/");i
EOF
%build
export CFLAGS="$RPM_OPT_FLAGS"
./configure --prefix=%{prefix}
%if %build_mandrake
export QTDIR=%{_libdir}/qt3
%endif
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/translations
install -m 755 mysqlcc $RPM_BUILD_ROOT%{prefix}/bin
install -m 644 {*.wav,syntax.txt} $RPM_BUILD_ROOT%{_datadir}/%{name}
install -m 644 translations/*.{qm,ts} \
               $RPM_BUILD_ROOT%{_datadir}/%{name}/translations

%if %build_mandrake
#Menu entry
mkdir -p $RPM_BUILD_ROOT%{_menudir}
cat <<EOF > $RPM_BUILD_ROOT%{_menudir}/%{name}
?package(%{name}): \
needs="x11" \
section="Applications/Databases" \
title="MySQLCC" \
longtitle="MySQLCC" \
command="%{_bindir}/mysqlcc" needs="X11" \
icon="%{name}.png"
EOF

#Menu icons
mkdir -p %{buildroot}/{%{_miconsdir},%{_liconsdir},%{_iconsdir}}
convert xpm/applicationIcon.xpm -resize 16x16 $RPM_BUILD_ROOT%{_miconsdir}/%{name}.png
convert xpm/applicationIcon.xpm $RPM_BUILD_ROOT%{_iconsdir}/%{name}.png
convert xpm/applicationIcon.xpm -resize 48x48 $RPM_BUILD_ROOT%{_liconsdir}/%{name}.png

%post
%{update_menus}

%postun
%{clean_menus}
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc Changelog.txt INSTALL.txt LICENSE.txt README.txt TODO.txt
%{_bindir}/mysqlcc
%{_datadir}/%{name}
%if %build_mandrake
%{_iconsdir}/%{name}.*
%{_miconsdir}/%{name}.*
%{_liconsdir}/%{name}.*
%{_menudir}/%{name}
%endif

%changelog
* Sun Jan 19 2003 Buchan Milne <bgmilne@linux-mandrake.com> 0.8.7-1mdk
- Inline the linux path patch for all rpm builds

* Thu Nov 28 2002 Buchan Milne <bgmilne@linux-mandrake.com> 0.8.6a-1mdk
- Add conditional Mandrake support

* Fri Apr 19 2002 Lenz Grimmer <lenz@mysql.com>

- initial version

