# -*- coding: utf-8 -*-
#
# «logging» - libmythbuntu class for Mythbuntu Cutom Logging
#
# This script:
# Copyright (C) 2009, Nick Fox, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
import datetime

class CustomLogging:
    
    def check_path(log_name,log_path):
        file_exists = False
        if os.path.exists(log_path + "/" + log_name + ".log"):
            file_exists = True
        return file_exists
    def append_log(app_name,log_name,log_path,log_data):
        log_to = log_path + "/" + log_name + ".log"
        ldata = "[ " + now + " ]"
        ldata += " -- " + log_data 
        ofile = open(log_to,"a")
        try:
            ofile.write(ldata)
            ofile.close()
        except IOError:
            print "Unable to write to log file."
    def create_log(app_name,log_name,log_path,log_data):
        if not os.path.exists(log_path):
            os.mkdir(log_path)
        log_to = log_path + "/" + log_name + ".log"
        ldata = "[ " + now + " ]"
        ldata += " -- " + log_data 
        ofile = open(log_to,"w")
        try:
            ofile.write(ldata)
            ofile.close()
        except IOError:
            print "Unable to write to log file."
