# -*- coding: utf-8 -*-
#
# «TotemHandler» - Totem Application lirc creator
#
# Copyright (C) 2007, Florian Boucault
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuLircGenerator.core import ProgramHandler

class TotemHandler(ProgramHandler):
    def __init__(self,lircd, lircrc,repeat,delay):
        application_name="totem"
        application_dictionary={ \
        "play":"play_pause", \
        "pause":"pause",\
        "forward":"seek_forward", \
        "rewind":"seek_backward", \
        "vol-":"volume_down", \
        "vol+":"volume_up", \
        "power":"quit", \
        "exit":"quit", \
        "up":"up", \
        "down":"down", \
        "right":"right", \
        "left":"left", \
        "menu":"menu", \
        "info":"show_playing", \
        "mute":"mute", \
        "dvd":"play_dvd" \
        }
        ProgramHandler.__init__(self,application_name,application_dictionary,lircd,lircrc,repeat,delay)
