#!/usr/bin/perl

use strict;
use CGI qw(:standard);
use HTML::Template;
use Config::Simple; 

require includes;

my $delete = param("delete");
my $title = param("title");
my $content = "";
my $file = "/etc/mythtv/mythexport/mythexport_settings.cfg";
my $cfg = new Config::Simple(syntax=>'ini');

if(-e $file){
    if(-s $file < 208){
        unlink($file);
    }
    else{
        $cfg->read($file) || die $cfg->error();
    }
}

my $template = HTML::Template->new(filename => 'template/template.tmpl');

if ($delete == 1){
    $cfg->delete("$title.sizeX");
    $cfg->delete("$title.sizeY");
    $cfg->delete("$title.audioBR");
    $cfg->delete("$title.videoBR");
    $cfg->delete("$title.device");
    $cfg->delete("$title.codec");
    $cfg->delete("$title.deletePeriod");
    $cfg->delete("$title.podcastName");
    $cfg->delete("$title.deinterlace");
    $cfg->delete("$title.removeCommercials");
    $cfg->delete("$title.audioChannels");
	$cfg->delete("$title.ffmpegArgs");
	$cfg->delete("$title.threads");
    $cfg->delete("$title.extension");
	$cfg->delete("$title.aspect");
    $cfg->write($file) || die $cfg->error();

    $content = "Configuration delete sucessfully.";
}
else{
    my $sizeX = param("sizeX"); 
    my $sizeY = param("sizeY"); 
	my $aspect = param("aspect");
    my $audioBR = param("audioBR"); 
    my $videoBR = param("videoBR"); 
    my $device = param("device"); 
    my $codec = param("codec"); 
    my $deletePeriod = param("deletePeriod"); 
    my $podcastName = param("podcastName"); 
    my $deinterlace = param("deinterlace");
	my $threads = param("threads");
    my $removeCommercials = param("removeCommercials");
    my $audioChannels = param("audioChannels");
    my $extension = param("extension");
	
	my $size = $sizeX . "x$sizeY";
	
	my ($audioChannelsText,$deinterlaceText,$codecText,$threadsText) = "";
	
	if($audioChannels ne ""){
		$audioChannelsText = " -ac $audioChannels";
	}
	if($deinterlace ne ""){
		$deinterlaceText = " -deinterlace";
	}
	if($codec eq "xvid"){
        $codecText = "libxvid";
    }
	else{
		$codecText = $codec;
	}
	if($threads ne ""){
		$threadsText = " -threads auto";
	}
	
    #my $cfg = new Config::Simple(syntax=>'ini');
    # or you could also do:
    # $cfg->autosave('ini')
	my $args = param("args");
    if ($device eq "mp3"){
	    $args = "-acodec libmp3lame -ac 2 -ab $audioBR -vn ";
    }
    elsif ($device eq "ipod" || $device eq "zune"){
	    if ($codecText eq "mpeg4" or $codecText eq "libxvid"){
		    $args = "-y -acodec libfaac -ab $audioBR -vcodec $codecText -b $videoBR -mbd 2 -flags +4mv+aic -trellis 2 -cmp 2 -subcmp 2 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect";
	    }
	    elsif ($codecText eq "h264"){
		    # First pass
		    $args = "-y -an -v 1 -vcodec h264 -b $videoBR -bt 175k -refs 1 -loop 1 -deblockalpha 0 -deblockbeta 0 -parti4x4 1 -partp8x8 1 -me full -subq 1 -me_range 21 -chroma 1 -slice 2 -bf 0 -level 30 -g 300 -keyint_min 30 -sc_threshold 40 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.7 -qmax 51 -qdiff 4 -i_qfactor 0.71428572 -maxrate 768k -bufsize 2M -cmp 1 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -f mp4 -pass 1 /dev/null";
		    # Second pass
		    $args .= "|-y -v 1 -vcodec h264 -b $videoBR -bt 175k -refs 1 -loop 1 -deblockalpha 0 -deblockbeta 0 -parti4x4 1 -partp8x8 1 -me full -subq 6 -me_range 21 -chroma 1 -slice 2 -bf 0 -level 30 -g 300 -keyint_min 30 -sc_threshold 40 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.7 -qmax 51 -qdiff 4 -i_qfactor 0.71428572 -maxrate 768k -bufsize 2M -cmp 1 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -acodec libfaac -ab $audioBR -ar 48000 -ac 2 -f mp4 -pass 2";
	    }
    }
    elsif ($device eq "psp"){
	    if ($codecText eq "mpeg4" or $codecText eq "libxvid"){
		    $args = "-y -acodec libfaac -ab $audioBR -vcodec $codecText -b $videoBR -ar 24000 -mbd 2 -flags +4mvaic -trellis 2 -cmp 2 -subcmp 2 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -r 30000/1001 -f psp";
	    }
	    elsif ($codecText eq "h264"){
		    $args = "|-y -acodec libfaac -ab $audioBR -vcodec h264 -b $videoBR -ar 48000 -mbd 2 -coder 1 -cmp 2 -subcmp 2 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -r 30000/1001 -title X -f psp -flags loop -trellis 2 -partitions parti4x4+parti8x8+partp4x4+partp8x8+partb8x8";
	    }
    }
    elsif ($device eq "archos"){
        if ($codecText eq "mpeg4" or $codecText eq "libxvid"){
            # ffmpeg line from courtesy of freymann
            $args = "-y -acodec libmp3lame -ab $audioBR -vcodec $codecText -b $videoBR -mbd 2 -flags +4mv+trell -aic 2 -cmp 2 -subcmp 2 -aspect $aspect -s $size$audioChannelsText$deinterlaceText$threadsText";
        }
    }
    elsif ($device eq "xbox360"){
	    if ($codecText eq "mpeg4" or $codecText eq "libxvid"){
		    $args = "-y -acodec libfaac -ab $audioBR -vcodec $codecText -b $videoBR -mbd 2 -flags +4mv+aic -trellis 2 -cmp 2 -subcmp 2 -s -aspect $aspect $size$audioChannelsText$deinterlaceText$threadsText";
	    }
	    elsif ($codecText eq "h264"){
		    # First pass
		    $args = "-y -an -v 1 -vcodec h264 -b $videoBR -bt 175k -refs 1 -loop 1 -deblockalpha 0 -deblockbeta 0 -parti4x4 1 -partp8x8 1 -me full -subq 1 -me_range 21 -chroma 1 -slice 2 -bf 0 -level 30 -g 300 -keyint_min 30 -sc_threshold 40 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.7 -qmax 51 -qdiff 4 -i_qfactor 0.71428572 -maxrate 768k -bufsize 2M -cmp 1 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -f mp4 -pass 1 /dev/null";
		    # Second pass
		    $args .= "|-y -v 1 -vcodec h264 -b $videoBR -bt 175k -refs 1 -loop 1 -deblockalpha 0 -deblockbeta 0 -parti4x4 1 -partp8x8 1 -me full -subq 6 -me_range 21 -chroma 1 -slice 2 -bf 0 -level 30 -g 300 -keyint_min 30 -sc_threshold 40 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.7 -qmax 51 -qdiff 4 -i_qfactor 0.71428572 -maxrate 768k -bufsize 2M -cmp 1 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -acodec libfaac -ab $audioBR -ar 48000 -ac 2 -f mp4 -pass 2";
	    }
    }
	elsif ($device eq "laptop"){
	    if ($codecText eq "mpeg4" or $codecText eq "libxvid"){
		    #$args = "-y -acodec libfaac -ab $audioBR -vcodec $codecText -b $videoBR -mbd 2 -flags +4mv+aic -trellis 2 -cmp 2 -subcmp 2 -s -aspect $aspect $size$audioChannelsText$deinterlaceText$threadsText";
            $args = "-y -acodec libfaac -ab $audioBR -vcodec $codecText -b $videoBR -mbd rd -flags +4mv+aic -trellis 2 -cmp 2 -subcmp 2 -g 300 -pass 1/2 -s $size -aspect $aspect $audioChannelsText$deinterlaceText$threadsText";
	    }
	    elsif ($codecText eq "h264"){
		    # First pass
		    $args = "-y -an -v 1 -vcodec h264 -b $videoBR -bt 175k -refs 1 -loop 1 -deblockalpha 0 -deblockbeta 0 -parti4x4 1 -partp8x8 1 -me full -subq 1 -me_range 21 -chroma 1 -slice 2 -bf 0 -level 30 -g 300 -keyint_min 30 -sc_threshold 40 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.7 -qmax 51 -qdiff 4 -i_qfactor 0.71428572 -maxrate 768k -bufsize 2M -cmp 1 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -f mp4 -pass 1 /dev/null";
		    # Second pass
		    $args .= "|-y -v 1 -vcodec h264 -b $videoBR -bt 175k -refs 1 -loop 1 -deblockalpha 0 -deblockbeta 0 -parti4x4 1 -partp8x8 1 -me full -subq 6 -me_range 21 -chroma 1 -slice 2 -bf 0 -level 30 -g 300 -keyint_min 30 -sc_threshold 40 -rc_eq 'blurCplx^(1-qComp)' -qcomp 0.7 -qmax 51 -qdiff 4 -i_qfactor 0.71428572 -maxrate 768k -bufsize 2M -cmp 1 -s $size$audioChannelsText$deinterlaceText$threadsText -aspect $aspect -acodec libfaac -ab $audioBR -ar 48000 -ac 2 -f mp4 -pass 2";
	    }
    }

    $cfg->param("$title.sizeX", $sizeX);
    $cfg->param("$title.sizeY", $sizeY);
    $cfg->param("$title.audioBR", $audioBR);
    $cfg->param("$title.videoBR", $videoBR);
    $cfg->param("$title.device", $device);
	$cfg->param("$title.aspect", $aspect);
    $cfg->param("$title.codec", $codec);
    $cfg->param("$title.deletePeriod", $deletePeriod);
    $cfg->param("$title.podcastName", $podcastName);
    $cfg->param("$title.deinterlace", $deinterlace);
    $cfg->param("$title.removeCommercials", $removeCommercials);
    $cfg->param("$title.audioChannels", $audioChannels);
	$cfg->param("$title.ffmpegArgs", $args);
	$cfg->param("$title.threads", $threads);
    $cfg->param("$title.extension", $extension);
    $cfg->write($file) || die $cfg->error();
    #$cfg->save($file) || die $cfg->error();

    $content = "<p>Configuration has been sucessfully saved.</p>";
}

$template->param(CONTENT => $content);
$template->param(LOCATION => "setup");

print generateContentType(), $template->output;
exit(0);
