#!/usr/bin/perl

use strict;
use CGI qw(:standard);
use HTML::Template;
use MythTV;
use Config::Simple; 

require includes;
my $connect = undef;
my $file = "/etc/mythtv/mythexport/mythexport_settings.cfg";
my $template = HTML::Template->new(filename => 'template/template.tmpl');
my ($script,$content) = "";

# if we have a valid config
if(-e $file && -s $file > 207){
    $script = "<script type=\"text/javascript\">//<![CDATA[
    function showBlocks(){
	    document.getElementById(\"hidden\").style.display=\"block\";
    }
    function hideBlocks(){
	    document.getElementById(\"hidden\").style.display=\"none\";
    }//]]>
    </script>";

    my $myth = new MythTV();
    # connect to database
    $connect = $myth->{'dbh'};

    my $cfg = new Config::Simple();
    $cfg->read($file) || die $cfg->error();

    my $block = param("block");

    my $test = $cfg->as_string();
    $test =~ s/\n//g;
    $test =~ s/^(.*?)\[//;
    $test =~ s/\](.*?)\[/,/g;
    $test =~ s/\](.*?)$//;

    my @blocks = split(",", $test);
    # find all recordings
    my $query = "SELECT title,subtitle,description,starttime,chanid
        FROM recorded order by title, subtitle, starttime";
    my $query_handle = $connect->prepare($query);
    $query_handle->execute()  || die "Unable to query mythexport table";

    $content = "<form id=\"form\" action=\"otg_job.cgi\" method=\"post\">
    <p>Choose a Location: <input type=\"text\" id=\"location\" name=\"location\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />
    <input type=\"radio\" id=\"otgFull\" name=\"type\" value=\"otgFull\" onclick=\"javascript:hideBlocks();\" checked=\"checked\" />Full Featured
    <input type=\"radio\" id=\"otgLight\" name=\"type\" value=\"otgLight\" onclick=\"javascript:showBlocks();\" />Lightweight<br />
    <span id=\"hidden\" style=\"display:none\">Choose an export profile: <select id=\"block\" name=\"block\" onchange=\"javascript:changeBlock();\">";

    foreach(@blocks){
	    $content .= "<option value=\"$_\"";
	    if ($_ eq $block){
		    $content .= " selected=\"selected\"";
	    }
	    $content .= ">$_</option>";
    }
    $content .= "</select><br /></span>Choose recordings to take on the go:
    <table border=\"1\"><th></th><th>Title</th><th>Description</th><th>Start Time</th>";

    while ( my ($title,$subtitle,$description,$starttime,$chanid) = $query_handle->fetchrow_array() ) {
	    $content .= "<tr><td><input type=\"checkbox\" name=\"recordings\" value=\"$chanid|$starttime\" /></td>
	    <td>$title";
	    if ($subtitle)
	    {
		    $content .= ": $subtitle";
	    }
	    $content .= "<td>$description</td><td>$starttime</td></tr>";
    }

    $content .= "</table><br /><span class=\"red\">* Are required</span>
    <br /><input type=\"submit\" id=\"submitButton\" name=\"submitButton\" value=\"Submit\" />
    </p></form>";
}
else{
    $content = "<p>Missing or Invalid configuration file, please create one.</p>";
}

$template->param(SCRIPT => $script);
$template->param(CONTENT => $content);
$template->param(LOCATION => "otg");

print generateContentType(), $template->output;
exit(0);
