#!/usr/bin/perl 

package PortableH264HighRes;

use ExportBase;

our @ISA = qw(ExportBase);

my $description = "High Resolution (800x400) Portable H264 Settings.";
my $devices = "High Resolution Android Devices (example Droid, Evo, N1), iPod Touch, iPhone, iPad";
my $notes = "Requires AAC, <a href=\"https://help.ubuntu.com/community/Medibuntu\">activate Medibuntu</a>";
my $version = "1.0";

sub new{
    my $class = shift;
    my $self = $class->SUPER::new(shift, shift, $description, $devices, $notes, $version);
    bless $self, $class;
    return $self;
}

sub export{
    my( $self ) = @_;

    system("ffmpeg -i \'$self->{_inputFile}\' -y -pass 1 -an -vcodec libx264 -vpre slowfirstpass -vpre ipod640 -b 1500kb -bt 1000kb -threads 0 -s 800x480 -aspect 16:9 -f ipod \'$self->{_outputFile}$self->{_extension}\' && ffmpeg -i \'$self->{_inputFile}\' -y -pass 2 -vcodec libx264 -vpre hq -vpre ipod640 -b 1500kb -bt 1000kb -threads 0 -s 800x480 -acodec libfaac -ab 192kb -ac 2 -aspect 16:9 -f ipod \'$self->{_outputFile}$self->{_extension}\'");

}

1;
