#include "DataSource.h"
#include "GNUstep.h"
#include "CodeParser.h"
#include "RenderHandler.h"
#include "MWKHandler.h"
#include "LinkHandler.h"
#include "LinkCheckHandler.h"

@implementation DataSource

- (BOOL) hasContentCreatedOnDate: (NSCalendarDate *) date
{
  int i, count = [wikiPages count];
  id item;
  NSCalendarDate *createdDate;
  NSString *title;
  for (i = 0; i < count; i++)
    {
      item = [wikiPages objectAtIndex: i];
      createdDate = [item objectForKey: CreatedDateKey];
      if ([date dayOfCommonEra] == [createdDate dayOfCommonEra])
	{
          title = [item objectForKey: TitleKey];
          if ([title isEqualToString: JournalTitle] == YES)
	    continue;
          if ([title isEqualToString: SearchResultTitle] == YES)
	    continue;
	  return YES;
	}
    }
  return NO;
}

- (BOOL) hasContentModifiedOnDate: (NSCalendarDate *) date
{
  return NO;
}

- (NSArray *) titlesCreatedOnDate: (NSCalendarDate *) date
{
  NSMutableArray *t = [[NSMutableArray alloc] init];
  int i, count = [wikiPages count];
  id item;
  NSCalendarDate *createdDate;
  NSString *title;

  for (i = 0; i < count; i++)
    {
      item = [wikiPages objectAtIndex: i];
      createdDate = [item objectForKey: CreatedDateKey];
      if ([date dayOfCommonEra] == [createdDate dayOfCommonEra])
	{
          title = [item objectForKey: TitleKey];
	  if ([title isEqualToString: SearchResultTitle] == YES)
            continue;
	  if ([title isEqualToString: JournalTitle] == YES)
            continue;
          [t addObject: [[item objectForKey: TitleKey] copy]];
	}
    }
  return AUTORELEASE(t);
}

- (NSArray *) titlesModifiedOnDate: (NSCalendarDate *) date
{
  return nil;
}

- (NSString *) xmlEntryOfTag: (NSString *) t value: (NSString *) v
{
  return [NSString stringWithFormat: @"<%@>%@</%@>\n", t, v, t];
}

- (unsigned int) indexOfTitle: (NSString *) title
{
  unsigned int i, count = [wikiPages count];
  for(i = 0; i < count; i++)
    {
      if ([[[wikiPages objectAtIndex: i] objectForKey: TitleKey]
		      isEqualToString: title])
	{
	  return i;
	}
    }
  return NSNotFound;

}

- (NSString *) titleAtIndex: (unsigned int) index
{
  if ((index >= [wikiPages count]) || (index == NSNotFound)) return;
  return AUTORELEASE([[[wikiPages objectAtIndex: index] objectForKey: TitleKey] copy]);
}

- (void) replaceContentOfLink: (NSString *) oldString
                   withString: (NSString *) newString
{
  NSEnumerator *e;
  NSString *content, *newContent;
  id object;
  e = [wikiPages objectEnumerator];
  while ((object = [e nextObject]))
    {
      content = [object objectForKey: ContentKey];
      //NSLog(@"OldContent \"%@\"", content);
      LinkHandler *handler = [[LinkHandler alloc] init];
      CodeParser *parser = [[CodeParser alloc] initWithCodeHandler: handler
                                               withString: content];
      [handler setOldLink: oldString replacedBy: newString];
      [parser parse];
      newContent = [handler updatedString];
      //NSLog(@"NewContent \"%@\"", newContent);
      [object setObject: AUTORELEASE([newContent copy])
	         forKey: ContentKey];
      RELEASE(handler);
      RELEASE(parser);
    }
}

- (BOOL) isLinkedByOthers: (NSString *) title
{
  NSEnumerator *e;
  NSString *content, *newContent;
  id object; 
  BOOL isLinked = NO;
  e = [wikiPages objectEnumerator];
  while ((object = [e nextObject]))
    { 
       content = [object objectForKey: ContentKey];
       //NSLog(@"OldContent \"%@\"", content);
       LinkCheckHandler *handler = [[LinkCheckHandler alloc] init];
       CodeParser *parser = [[CodeParser alloc] initWithCodeHandler: handler
                                                         withString: content];
      [handler setStringOfLink: title];
      [parser parse];
      if ([handler isExisted] == YES)
        {
 	  RELEASE(handler);
	  RELEASE(parser);
          return YES;
        }
      RELEASE(handler);
      RELEASE(parser);
    }
  return NO;
}

- (void) replaceTitle: (NSString *) oldTitle withTitle: (NSString *) newTitle
{
  unsigned int index = [self indexOfTitle: oldTitle];
  if (index != NSNotFound)
    {
      [[wikiPages objectAtIndex: index] setObject: AUTORELEASE([newTitle copy])
	                                   forKey: TitleKey];
    }
}

- (BOOL) canRemoveContentOfTitle: (NSString *) title
{
  if ((title == nil) || ([title isEqualToString: @""])
		     || ([title isEqualToString: HomeTitle]))
    return NO;
  return YES;
}

- (BOOL) canEditContentOfTitle: (NSString *) title
{
  if ((title == nil) || ([title isEqualToString: @""])
		     || ([title isEqualToString: SearchResultTitle])
		     || ([title isEqualToString: JournalTitle]))
    return NO;
  return YES;
}

- (void) removeContentOfTitle: (NSString *) title
{
  unsigned int index;
  if ([self canRemoveContentOfTitle: title] == NO)
    return;

  index = [self indexOfTitle: title];
  if (index != NSNotFound)
    [wikiPages removeObjectAtIndex: [self indexOfTitle: title]];
}

- (void) setDataFromContentOfFile: (NSString *) content
{
  MWKHandler *handler = [[MWKHandler alloc] init];
  CodeParser *parser = [[CodeParser alloc] initWithCodeHandler: handler
                                                    withString: content];
  [parser parse];
  [wikiPages setArray: [handler wikiPages]];

  RELEASE(handler);
  RELEASE(parser);
}

- (NSData *) dataOfIndexFile
{
  id item;
  NSEnumerator *e;
  NSString *title;
  id date;
  NSMutableString *ms = [[NSMutableString alloc] init];
  [ms appendString: @"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"];
  [ms appendString: @"<mywiki>\n"];
  [ms appendString: [self xmlEntryOfTag: XMLVersionTag value: @"0.9"]];

  e = [wikiPages objectEnumerator];
  while ((item = [e nextObject]))
    {
      title = [item objectForKey: TitleKey];
      // Don't save search result
      if ([title isEqualToString: SearchResultTitle])
	continue;
      if ([title isEqualToString: JournalTitle])
	continue;
      [ms appendString: @"<data>\n"];
      [ms appendString: [self xmlEntryOfTag: XMLTitleTag value: title]];

      date = [item objectForKey: CreatedDateKey];
      if (date == nil)
	date = [NSCalendarDate calendarDate];
      date = [date descriptionWithCalendarFormat: DateFormat];
      [ms appendString: [self xmlEntryOfTag: XMLCreatedDateTag value: date]];

      date = [item objectForKey: ModifiedDateKey];
      if (date == nil)
	date = [NSCalendarDate calendarDate] ;
      date = [date descriptionWithCalendarFormat: DateFormat];
      [ms appendString: [self xmlEntryOfTag: XMLModifiedDateTag value: date]];

      [ms appendString: [self xmlEntryOfTag: XMLContentTag value: [item objectForKey: ContentKey]]];
      [ms appendString: @"</data>\n"];
    }

  [ms appendString: @"</mywiki>\n"];
  AUTORELEASE(ms);
  return [ms dataUsingEncoding: NSUTF8StringEncoding];
}

- (NSAttributedString *) renderWithTitle: (NSString *) string
{
  CodeParser *parser;
  NSAttributedString *as = nil;
  NSString *content = [self sourceWithTitle: string];

  if (content == nil)
    return nil;

  // Render page
  RenderHandler *handler = [[RenderHandler alloc] init];
  parser = [[CodeParser alloc] initWithCodeHandler: handler
                                        withString: content];
  [parser parse];

  AUTORELEASE(handler);
  AUTORELEASE(parser);

  ASSIGN(as, [handler renderedString]);
  return as;
}

- (NSString *) sourceWithTitle: (NSString *) string
{
  unsigned int index = [self indexOfTitle: string];
  if (index != NSNotFound)
    return AUTORELEASE([[[wikiPages objectAtIndex: index] objectForKey: ContentKey] copy]);
  else
    return nil;
}

- (void) setContent: (NSString *) string withTitle: (NSString *) title
{
  unsigned int index = [self indexOfTitle: title];
  NSCalendarDate *date = [NSCalendarDate calendarDate];

  if (index == NSNotFound)
    {
      NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithObjectsAndKeys: 
	  AUTORELEASE([string copy]), ContentKey,
	  AUTORELEASE([title copy]), TitleKey, 
	  AUTORELEASE([date copy]), CreatedDateKey,
	  AUTORELEASE([date copy]), ModifiedDateKey, nil];
      if ([title isEqualToString: HomeTitle])
	{
	  [wikiPages insertObject: dict atIndex: 0];
	}
      else if ([title isEqualToString: SearchResultTitle])
	{
	  [wikiPages insertObject: dict atIndex: 1];
	}
      else
        [wikiPages addObject: dict];
    }
  else
    {
      [[wikiPages objectAtIndex: index] setObject: AUTORELEASE([string copy])
	                                   forKey: ContentKey];
      [[wikiPages objectAtIndex: index] setObject: AUTORELEASE([date copy])
	                                   forKey: ModifiedDateKey];
    }
}

- (id) init
{
  self = [super init];
  wikiPages = [[NSMutableArray alloc] init];
  fileContent = [[NSMutableString alloc] init];
  return self;
}

- (void) dealloc
{
  RELEASE(wikiPages);
  RELEASE(fileContent);
}

- (unsigned int) numberOfPages
{
  return [wikiPages count];
}

- (NSArray *) titles
{
  NSMutableArray *titles = [[NSMutableArray alloc] init];
  unsigned int i, count = [wikiPages count];
  for (i = 0; i < count; i++)
    {
      [titles addObject: [[wikiPages objectAtIndex: i] objectForKey: TitleKey]];
    }
  return AUTORELEASE(titles);
}

@end
