#ifndef __MyDocument__
#define __MyDocument__

#include <AppKit/AppKit.h>
#include "DataSource.h"

static NSString *IndexFile = @"index.xml";

@interface MyDocument : NSDocument
{
    IBOutlet id editButton;
    IBOutlet id addButton;
    IBOutlet id deleteButton;
    IBOutlet id calendarButton;
    IBOutlet id backButton;
    IBOutlet id forwardButton;
    IBOutlet id textView;
    IBOutlet id tableView;
    IBOutlet NSWindow *window;
    IBOutlet id calendarView;
    IBOutlet id tableScrollView;
#ifdef GNUSTEP
    IBOutlet id splitView;
#endif

    DataSource *dataSource;
    NSString *index;
    BOOL isDocumentEdited;
    NSMutableArray *history;
    int historyIndex;
    BOOL backOrForwardAction;
}

// From Window 
- (IBAction)editAction:(id)sender;
- (IBAction)homeAction:(id)sender;
- (IBAction)backAction:(id)sender;
- (IBAction)forwardAction:(id)sender;
- (IBAction)addAction:(id)sender;
- (IBAction)deleteAction:(id)sender;
- (IBAction)searchAction:(id)sender;
- (IBAction)calendarAction:(id)sender;

// From Menu
- (IBAction)editMenuAction:(id)sender;

- (BOOL) selectTitle: (NSString *) title;
- (void) updateTextView;
@end

#endif
