<?php
# $Id: contacts.php,v 1.6 2002/06/22 07:35:34 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","contacts");
define("PAGE_TITLE","Contacts");
define("OBJECTTYPE","contact");

require_once("local.inc");
include_once(NGT_LIB."head.inc");

$alter = '';
$rows = array();
$errmsg = '';
$message = '';
$objects = PluginGetObjects(OBJECTTYPE);


if( isset($objects) ) {
	uasort($objects,"NagiosUasortObjectName");
	foreach($objects as $key => $object) {

		$alter = ($alter != "alter1") ? "alter1" : "alter2";
		$inheritance = '';

		$name = isset($object['name']) ?
			$object['name'] : $object[OBJECTTYPE.'_name'];
		$alias = isset($object['alias']) ? $object['alias'] : '';

		# Is this a inheritable object?
		if( !empty($object['name']) ) {
		$cntinh = NagiosCountInherited(OBJECTTYPE,$name);
			$inheritance = 'used by '.$cntinh.' objects';
		} else if( !empty($object['use']) ) {
			$inheritance = 'uses '.$object['use'];
		} else {
			$inheritance = '';
		}

		$rows[] = <<<HTML
<tr class="$alter">
  <td><a href="contactedit.php?objectid={$key}">Edit</a></td>
  <td>{$object['contact_name']}</td>
  <td>{$alias}</td>
  <td>{$object['host_notification_period']}</td>
  <td>{$object['service_notification_period']}</td>
  <td>{$inheritance}</td>
</tr>
HTML;

	} # foreach
} else {
	$message = "No '".OBJECTTYPE."'-objects found.";
}


?>
<table border="0" cellpadding="5" cellspacing="0">
<tr>
  <td colspan="7" align="left">
  <b><?=ErrorMsg($errmsg)?>
  <?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="6">
  <form action="contactedit.php">
  <input type="hidden" name="contactname" value="newobject">
  <input type="submit" value="New">
  </form>
  </td>
</tr>
<tr class="rowsep">
  <td colspan="3">&nbsp;</td>
  <td colspan="2" align="center">Notification period</td>
  <td colspan="1">&nbsp;</td>
</tr>
<tr class="rowsep">
  <td>&nbsp;</td>
  <td>Contact Name</td>
  <td>Alias</td>
  <td>for hosts</td>
  <td>for services</td>
  <td>Inheritance</td>
</tr>
<?=implode("\n",$rows)?>
</table>

<?
# Beautification
if( !is_array($objects) ) {
        print "<br><br><br><br><br><br><br><br>";
}
include_once(NGT_LIB."tail.inc");
?>
