<?php
# $Id: functions.inc,v 1.13 2002/06/21 14:24:20 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#
# void PrintArray (mixed expression)
#
# Same as print_r function in PHP but PrintArray prints surrounds it with a
# <pre> HTML tag.
#
function PrintArray($expression) 
{
	print("<pre>");
	print_r($expression);
	print("</pre>");
}

#
# void ErrorMsg(string msg)
#
# Prints an error message (not very smart)
#
function ErrorMsg($msg) 
{
	if( $msg != '' ) {
		print('<br><font class="error">'.$msg."</font><br>\n");
	}
}

#
# string FileSelect(string dirname, string name, string selected
#		[, mixed fileext] )
#
# Creates a dropdown of files of with a certain file extention in a directory
#
# Return a HTML select or a string when something went wrong.
#
# Note: not finished!
# 
function FileSelect($dirname,$name,$selected,$fileext = NULL)
{
	$exts = array();
	$option = '   <option value="%s" %s> %s';

	$dir = @opendir($dirname);
	if( $dir == FALSE ) {
		return "Could not open dir $dir";
	}
 	if( $fileext != NULL ) {
		if( is_array($fileext) == FALSE) {
			$exts[] = $fileext;
		} else {
			$exts = $fileext;
		}
	}
	while (($file = readdir($dir)) !== false) {
		$add = TRUE;
		if( preg_match("/\.(\w+)$/",$file,$m) == TRUE) {
			$ext = $m[1];
		} else {
			$ext = '';
		}

		if( filetype($dirname."/".$file) != "file") {
			$add = FALSE;
		} else if( in_array($ext,$exts) && $fileext != NULL ) {
			$add = TRUE;
		} else if( $fileext != NULL ) {
			$add = FALSE;
		}

		if( $add == TRUE ) { 
			$sel = ($selected == $file) ? 'selected' : '';
			$opts[$file] = sprintf($option, $file, $sel, $file);
		}
	}

	ksort($opts);
	$options = implode("\n",$opts);

	return <<<HTML
<select name="$name">
<option value="">
$options
</select>
HTML;
}

#
# array PrepareObject(string name, string type, array objects)
#
# Helper function for the *edit.php scripts. It takes some information and
# figures out whether it is an existing object or a new one. In case of a new
# one it will try to set some default values
#
# Returns a hash containing object information.
#
function PrepareObject($name,$type,$objects)
{
	global $message, $errmsg;
	$object = array();

	if( $name != "newobject" ) {
		$object = NagiosSearchObject($type,$objects,$name);
		if( $object == NULL ) {
			$errmsg = "<br> '$type'-object $name not found!";
			$name = "newobject";
		}
	}

	if( $name == "newobject" ) { 
		$object['__cfgfile'] = @$objects[$type][0]['__cfgfile'];
		$object['__type'] = $type;
		$message = "New '$type'-object.";
	}
	
	return $object;
}

#
# string ObjectUsage(string name, string objecttype, array userobjs)
#
# Creates a summary for an object from $userobjs.
#
# Returns HTML code. 
#
function ObjectUsage($name, $objecttype, $userobjs) 
{
	$output = array();

	foreach($userobjs as $objectgroup)
		$cntusers += count($objectgroup);
	$output[] = <<<HTML
<tr class="rowsep">
  <td colspan="3">
  The following <b>$cntusers</b> object(s) are using this object:
  </td>
</tr>
HTML;
	foreach($userobjs as $type => $objectgroup) {
		foreach($objectgroup as $key => $userobj) {

			# Handle service-objects
			if( $type == 'service' ) {
				if( empty($userobj['name']) ) {
					$text = $userobj['service_description'].
					   ' on host '.$userobj['host_name'];
				} else {
					$text = ' template '.$userobj['name'];
				}
			} else {
				$text = $userobj[$type.'_name'];
			}
			$output[] = <<<HTML
<tr>
  <td colspan="2">'$type'-object:
  <a href="{$type}edit.php?objectid=$key">$text</a>
</tr>
HTML;

		}
	}

	return(implode("\n",$output));
}

#
# string ObjectInheritance(array objects, string name, string objecttype)
#
# Generates HTML showing which objects are inheriting from this object.
#
# Returns HTML code. 
#
function ObjectInheritance($name, $objecttype)
{

	$objects = PluginGetObjects($objecttype);

	if( !is_array($objects) ) {
		return(NULL);
	}

	$output = array();
	$ahreffmt = '<a href="%sedit.php?objectid=%s">%s</a>';

	$output[] = <<<HTML
<tr class="rowsep">
  <td colspan="3">
  The following object(s) inherit from this object:
  </td>
</tr>
HTML;

	foreach($objects as $key => $inhobj) {

		if( !isset($inhobj['use']) ) continue;
		if( $inhobj['use'] != $name ) continue;

		# We have one
		if( $objecttype == 'service' ) {
			$inhname = $inhobj['service_description'].
				' on host '.$inhobj['host_name'];
		} else {
			$inhname = $inhobj[$objecttype.'_name'];
		}
		$ahref = sprintf($ahreffmt, 
			$objecttype, $key, $inhname);

		$output[] = <<<HTML
<tr>
  <td colspan="2">$ahref</td>
</tr>
HTML;
	}

	return(implode("\n",$output));
}

?>
