#!/usr/bin/perl -w

# SrvExtWriteHostextInfo.pm- writes an Hostextinfo for hostgraph action.
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: SrvExtWriteHostextInfo.pm 1505 2006-11-17 15:29:29Z gmueller $

#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# $Id: SrvExtWriteHostextInfo.pm 1505 2006-11-17 15:29:29Z gmueller $


#######################################################
# Please keep in mind that this hook is just an example
# what can be done bevor writing ServiceExtInfo
#######################################################

package NagiosGrapher::Hooks::SrvExtWriteHostextInfo;

use NagiosGrapher::Hooks::Generic;

use vars qw (
	@ISA
);

@ISA = ('NagiosGrapher::Hooks::Generic');

# The overwritten init sub.
sub init {
	$self = shift;

	$self->SetTypes (
		'before_serviceext',
		'before_rrdupdate'
	);

	return $self->SUPER::init(@_);
}

# Checks if an entry exists
sub check_entry_exists {
	my $self = shift;

	unless ( -e $self->{'file'}) {
		return undef;
	}

	open HOSTEXT, '<', $self->{'file'};
	my @lines = <HOSTEXT>;
	close HOSTEXT;

	$self->print_log('Checking if entry exists ...');

	my $host = $self->Host;

	foreach my $line (@lines) {
		if ($line =~ m/.*?host_name.*?$host/g) {
			$self->print_log('Hostextentry found ... abort!');

			return 1;
		}
	}

	return undef;
}

# write the info file with the current data
sub write_hostextinfo {
	my $self = shift;
	my ($content) = @_;

	if ($content) {
		open HOSTEXT, '>>', $self->{'file'};
		print HOSTEXT $content;
		close HOSTEXT;

		return 1;
	}

	return undef;

}

# inherited prepare sub, check the entry
sub prepare {
	my $self = shift;

	$self->{'dir'} = '/usr/local/nagios/etc/hostext/';
	$self->{'file'} = $self->{'dir'}. $self->Host. '.cfg';

	if (!$self->check_entry_exists()) {
		return 1;
	}

	return undef;
}

# commit, write if prepare runs out successfully
sub commit {
	my $self = shift;
	my $values = $self->Values;

	my $string = undef;
	my $url = sprintf('%s?host=%s&service=%s&action=hostgraph&timeframe=-129600',
		$self->NG->get_ngraphercfg_value('url'),
		$self->Host,
		$self->Service);

	$string .= sprintf("# ->> Hostext for host %s\n", $self->Host);
	$string .= "define hostextinfo{\n";
	$string .= sprintf("\thost_name\t%s\n", $self->Host);
	$string .= sprintf("\tnotes_url\t%s\n", $url);
	$string .= sprintf("\tnotes\t\t%s\n", 'All services about the host');
	$string .= "}\n";

	$self->print_log('Writing to file: '. $self->{file});
	my $re = $self->write_hostextinfo($string);

	if ($re) {
		$self->print_log('Writing success ...');
	}

	return $re;
}

# cleanup nothing to do.
sub cleanup {
	my $self = shift;
	return 1;
}

1;