#!/usr/bin/perl -w

# graphs.cgi - The Frontend of the nagios grapher
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: graphs.cgi 1328 2006-08-01 10:10:41Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Main 
no warnings qw/uninitialized/;
use strict;
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use URI::Escape;
use File::Basename;
use NagiosGrapher::HTML;


use vars qw (
    $self
    $stylesheet
    $q
    %params
    $height
    $width
    $host
    $service

    $title


    $xmlhash
    $ng
    $h
);

$| = 1;

$h = NagiosGrapher::HTML->new();
$ng = $h->NG;
$q = new CGI;

unless (defined $ng) {
  die ('NagiosGrapher daemon not running or no objectcache available!');
}

sub action_graph;
sub action_rrdinfo;
sub action_showtemplate;
sub action_showcalendar;


#$xmlhash = $ng->get_ngrapherxml;
# If the current differs from the selected, start the default service ...

$xmlhash = $h->getXMLHashWithMultigraph();
if ($h->Param('old_host') && length($h->Param('old_host')) > 0 && $h->Param('old_host') ne $h->Host || $h->isAction('hostgraph')) {
  if ($h->isAction('hostgraph')) {
    $service = [sort(keys(%{$xmlhash->{host}->{$h->Host}->{service}}))]->[0];
  }
  else {
    $service = [sort(keys(%{$xmlhash->{host}->{$h->Host}->{service}}))]->[1];
  }
    $h->Service($service);
}

# Starting the HTML Output ...
$h->htmlHeader();

# ---
# The ACTIONS
# ---
unless (defined($ng)) {
  print '<h4>collect2.pl is not running ...</h4>';
  print '<p>The NagiosGrapher Object Cache was not found. Please make shure that the collect2.pl daemon is running. (<a href="'. $q->self_url(). '">reload</a>)</p>';
}
else {
  if ($h->isAction('graph', 'hostgraph')) {
    action_graph();
  }
  elsif($h->isAction('rrdinfo')) {
    action_rrdinfo();
  }
  elsif($h->isAction('showtemplate')) {
    action_showtemplate();
  }
  elsif($h->isAction('calendar')) {
    action_showcalendar();
  }
  else {
    print '<h4>No action found ('. $h->getAction(). ') ...</h4>';
  }
}


# End HTML Output ...
print $q->end_html();

# Generic END
exit(0);

sub action_showtemplate {
  # The maintable
  print "<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\" class=\"table1\" align=\"left\">\n";
  print '<tr><td>'. "\n";

  # The MENU:
  print $q->span({-class => "head1"}, "NETWAYS Nagios Grapher v$NagiosGrapher::VERSION"), "&nbsp;(Logged in as $ENV{REMOTE_USER})";
  print "<hr size=\"1\" />";

  print $q->span({-class => "head2"}, "Graphtemplate for <code>". $h->Service. "</code>:"). "&nbsp;";
  print '<br />'. $q->a({-href=>'Javascript: history.back();'}, 'Go back');
  print '<br /><br />';

  my @blocks = $ng->get_ngrapherdef($h->Service);
  if (@blocks > 0) {
  print '<table>';
  foreach (@blocks) {

    print '<tr><td colspan="3"><b>define {</b></td></tr>';

    foreach my $template_key (sort(keys(%{ $_ }))) {
      next if ($template_key eq 'define');
      print '<tr>';

      print '<td width="30">&nbsp;</td>';
      print '<td width="120">'. $template_key. '</td>';
      print '<td>'. $_->{$template_key}. '</td>';

      print '</tr>';
    }

    print '<tr><td colspan="3"><b>}</b></td></tr>';
    print '<tr><td colspan="3">&nbsp;</td></tr>';

  }
  print '</table>';
  }
  else {
    print '<br /><b>No templatedata found !</b>';
  }
  print '</td></tr></table>';
}

sub action_rrdinfo {
  # The maintable
  print "<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\" class=\"table1\" align=\"left\">\n";
  print '<tr><td>'. "\n";

  # The MENU:
  print $q->span({-class => "head1"}, "NETWAYS Nagios Grapher v$NagiosGrapher::VERSION"), "&nbsp;(Logged in as $ENV{REMOTE_USER})";
  print "<hr size=\"1\" />";

  print $q->span({-class => "head2"}, "RRDInfo for <code>". $h->Host. "</code>, <code>". $h->Service. "</code>:"). "&nbsp;";
  print '<br />'. $q->a({-href=>'Javascript: history.back();'}, 'Go back');
  print '<br /><br />';


  $xmlhash = $ng->get_ngrapherxml;

  if (exists($xmlhash->{host}->{$h->Host}->{service}->{$h->Service}->{rrd_file})) {
    my $info = $ng->rrd_info($h->Host, $xmlhash->{host}->{$h->Host}->{service}->{$h->Service}->{rrd_file});
    print '<table>';
    my $i=0;
    foreach (sort(keys(%{ $info }))) {
      $i++;
      if ($i%2) {
        print '<tr>';
      }
      else {
        print '<tr bgcolor="#f1f1f1">'
      }
      print '<td><b>'. $_. ':</b></td>';
      print '<td>'. ($info->{$_} || '<small style="color: #c0c0c0;">(empty)</small>'). '</td>';
      print '</tr>';
    }
    print '</table>';
  }
  else {
    print '<br /><b>No RRDFile found !</b>';
  }

  print '</td></tr></table>';
}

sub action_graph {
  local our @graph_data;
  # XML HASH
  $xmlhash = $h->getXMLHashWithMultigraph();

  use Data::Dumper;
  # printf('<pre>%s</pre>', Dumper($xmlhash));

  # Use the host/service browser (COMMON) or not
  $h->checkPageBrowserAuth();

  # If the current differs from the selected, start the default service ...
  if ($h->Param('old_host') ne $h->Host) {
      $service = [sort(keys(%{$xmlhash->{host}->{$h->Host}->{service}}))]->[1];
      $h->Service($service);
  }

  # Check if it is a multigraph
  my $multigraph = 0;
  unless(exists($xmlhash->{host}->{$host}->{service}->{$service}->{rrd_file})) {
    $multigraph = 1;
  }


  if ($h->isAction('hostgraph')) {

    if ($xmlhash->{host}->{$h->Host}->{service}) {
        foreach (sort keys(%{ $xmlhash->{host}->{$h->Host}->{service} })) {
          my $sd = $xmlhash->{host}->{$h->Host}->{service}->{$_};

          my %time_data = ();

          if ( ($h->Param('start') || $h->Param('stop')) && $h->checkUseTimefilter()) {
            %time_data = (
              'Start' => uri_escape($h->Param('start')),
              'End' => uri_escape($h->Param('stop')),
            );
          }
          elsif ($h->Param('timeframe') && $h->checkUseTimefilter()) {
            %time_data = (
              'Start' => $h->Param('timeframe'),
            );
          }

          push @graph_data, {
            'Title' => $_,
            'Host' => $h->Host,
            'Service' => $_,
            %time_data
          } if ($sd->{rrd_file});
        }
    }

  }
  elsif ( ($h->Param('start') || $h->Param('stop')) && $h->checkUseTimefilter()) {
    push @graph_data, {
      'Title' => 'Custom',
      'Start' => uri_escape($h->Param('start')),
      'End' => uri_escape($h->Param('stop')),
      'Host' => $h->Host,
      'Service' => $h->Service,
    };
  }
  else {
    my %timeframes = (
      '1 Current'	=> '-5400',
      '2 Daily'		=> '-129600',
      '3 Weekly'	=> '-907200',
      '4 Monthly'	=> '-4017600',
      '5 Yearly'	=> '-48211200',
    );

    foreach (sort keys(%timeframes)) {
      push @graph_data, {
        'Title' => $_,
        'Start' => $timeframes{$_},
        'Host' => $h->Host,
        'Service' => $h->Service,
      };
    }
  }

  # The maintable
  print "<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\" class=\"table1\" align=\"left\">\n";
  print '<tr><td colspan="2">'. "\n";

  # The MENU:
  print $q->span({-class => "head1"}, "NETWAYS Nagios Grapher v$NagiosGrapher::VERSION"), "&nbsp;(Logged in as $ENV{REMOTE_USER})";
  print "<hr size=\"1\" />";

  print '<table border="0" cellpadding="0" cellspacing="0" style="width: 100%;"><tr><td>';
  # Graph description

  # The image anchors
  foreach (@graph_data) {
      print "[&nbsp;",
          $q->a({href=>$h->SelfURL. "#". $_->{Title}}, $_->{Title}),
          "&nbsp;]&nbsp;",
          "\n";
  }

  # Close and reload link
  print
      '</td><td align="right">',
      "[&nbsp;", $q->a({-href=>"#", -onclick=>"window.location.reload(); return true;"}, "Reload"), "&nbsp;]",
      "&nbsp;&nbsp;[&nbsp;", $q->a({-href=>"#", -onclick=>"top.close(); return true;"}, "Close"), "&nbsp;]",
      '</td></tr></table>';

  # Starting the form
  print
      "\n\n",
      $q->start_form(-method=>"get", -action=>$h->SelfURL(Type => 'script'), -enctype=>"application/x-www-form-urlencoded");

  $h->htmlHiddenFields();

  print '<table border="0" cellpadding="2" cellspacing="0">';
      # Default image options
    $h->htmlDefaultImageSelector();
      # Displaying the page combo if needed...
      $h->htmlPageSelector();
      # Type combo
    $h->htmlRRDTypeCombo();
    # Timeframes
    $h->htmlTimeFilter();
    # Host/Service browser
    $h->htmlHostServiceBrowser();
      print
      '<tr>
        <td>&nbsp;</td>
        <td colspan="4">'. (!$h->isAction('graph') ? '&nbsp;' : ('[&nbsp;'. $q->a({-href=>$h->SelfURL. ';action=rrdinfo'}, 'RRDInfo'). '&nbsp;]&nbsp;&nbsp;[&nbsp;'. $q->a({-href=>$h->SelfURL. ';action=showtemplate'}, 'TemplateInfo'). '&nbsp;]')). '</td>
        <td align="right">', $q->submit(-name=>"cmd_change", -value=>"Change"), '</td></tr>',
      '</table>';

    print
      $q->endform,
      "\n\n";

  print '<table border="0" cellspacing="0">'. "\n";

  # Displaying the RRD's
  foreach my $graph (@graph_data) {
    $h->htmlGraphImage(%$graph);
  }

  # Footer
  print
      '<tr><td colspan="2" align="right">',
      'Nagios Grapher v'. $NagiosGrapher::VERSION. '&nbsp;&copy;&nbsp;<span style="font-style: bolder">MMIV, MMV</span>&nbsp;(2004, 2005)&nbsp;',
      $q->a({-href=>"http://www.netways.de/", -target=>"_blank"}, "NETWAYS GmbH"),
      '</td></tr>';

  print "</table></td></tr></table>\n";
}

sub action_showcalendar {
  use Calendar::Simple;

  my @today = localtime( time() );

  my @days = qw(Sun Mon Tue Wed Thu Fri Sat);

  my $display_month = $params{month};
  my $display_year = $params{year};
  my $field  = $params{field};

  unless ($display_month) {
    $display_month = $today[4] + 1;
    $display_year = $today[5] + 1900;
  }

  my ($prev_year, $next_year, $prev_month, $next_month);
  $prev_month = $next_month = $display_month;
  $prev_year = $next_year = $display_year;

  $next_month++;
  $prev_month--;

  if ($display_month == 12) {
    $next_year++;
    $next_month = 1;
  }
  elsif ($display_month == 1) {
    $prev_year--;
    $prev_month = 12;
  }

  my @months = qw(January February March April May June July August September October November December);
  my @month = calendar($display_month, $display_year);

  print q(
    <script language="Javascript" type="text/javascript">
    <!-- // <![CDATA[
      function updateParent(field, value) {
        if (window.opener) {
          window.opener.document.getElementById(field).value = value;
          window.close();

          return true;
        }

        return false;
      }
    // ]]> -->
    </script>
  );

  print q(<table cellpadding="4" border="1" style="border-collapse: collapse;">);

  print qq(
    <caption>
      <a href="$h->SelfURL(Type => 'script')?action=calendar;month=$prev_month;year=$prev_year">Prev</a>
      &nbsp;&nbsp;&nbsp;&nbsp;<b>$months[$display_month-1]&nbsp;$display_year</b>&nbsp;&nbsp;&nbsp;&nbsp;
      <a href="$h->SelfURL(Type => 'script')?action=calendar;month=$next_month;year=$next_year">Next</a>
    </caption>
  );

  print q(<tr>);
  foreach my $day (@days) {
    print qq(<td style="border: 1px #333333 solid;"><b>$day</b></td>);
  }
  print q(</tr>);

  foreach my $week (@month) {
    print q(<tr>);

    foreach my $day (@$week) {
      if ($day && $day == $today[3] && $display_month == ($today[4]+1) && $display_year == ($today[5] + 1900)) {
        print '<td style="border: 1px #333333 solid; background-color: #c0c0c0;">';
      }
      else {
        print '<td style="border: 1px #333333 solid;">';
      }

      my $date_string = sprintf('00:00 %02d.%02d.%04d', $day, $display_month, $display_year );

      print defined $day ? $q->a({
        href=>'#',
        onclick=>"javascript:updateParent('$field', '$date_string');"
      }, $day) : '&nbsp;';
      print '</td>';
    }

    print q(</tr>);
  }

  print q(</table>);
  print qq(<br /><a href="#" onclick="updateParent('$field', '');">Delete</a>);
  print q(&nbsp;|&nbsp;<a href="#" onclick="javascript:window.close();return false;">Close</a>);
}


