require 'gem2deb/rake/spectask'
require 'gem2deb/rake/testtask'

EXCLUDED_TESTS=['nanoc/test/filters/test_markaby.rb',
                'nanoc/test/filters/test_rainpress.rb']


Gem2Deb::Rake::TestTask.new(:test_nanoc) do |t|
  t.libs = ['nanoc/test', 'nanoc/lib', 'nanoc-core/lib', 'nanoc-cli/lib'] 
  t.test_files = FileList['nanoc/test/**/*_spec.rb'] + FileList['nanoc/test/**/test_*.rb']-EXCLUDED_TESTS
end


Gem2Deb::Rake::RSpecTask.new(:spec) do |spec|
  spec.pattern = './nanoc/spec/**/*_spec.rb'
  spec.exclude_pattern = './nanoc/spec/nanoc/{filters/less_spec.rb,cli/commands/view_spec.rb}'
  spec.rspec_opts = '-r ./nanoc/spec/spec_helper.rb --color'
end

Gem2Deb::Rake::RSpecTask.new(:spec_core) do |spec|
  spec.pattern = './nanoc-core/spec/**/*_spec.rb'
  spec.rspec_opts = '-r ./nanoc-core/spec/spec_helper.rb --color'
end

Gem2Deb::Rake::RSpecTask.new(:spec_cli) do |spec|
  spec.pattern = './nanoc-cli/spec/**/*_spec.rb'
  spec.rspec_opts = '-r ./nanoc-cli/spec/spec_helper.rb --color'
end

Gem2Deb::Rake::RSpecTask.new(:spec_live) do |spec|
  spec.pattern = './nanoc-live/spec/**/*_spec.rb'
  spec.rspec_opts = '-r ./nanoc-live/spec/spec_helper.rb --color'
end

task default: [:test_nanoc, :spec, :spec_core, :spec_cli, :spec_live]
