#include <stdlib.h>
#include <stdio.h>

static int next_id = 0;
struct my_struct
{
  int id;
};

/* you must have the following symbols */
/* see John Cresswell document for details : */
/* AGATA PSA and Tracking Algorithm Integration*/
void process_config (char *directory_path, unsigned int *error_code);
struct my_struct *process_register (unsigned int *error_code);
void process_block (struct my_struct *algo_data,
		    void *input_buffer,
                    unsigned int size_of_input_buffer,
		    void *output_buffer,
		    unsigned int size_of_output_buffer,
		    unsigned int *used_size_of_output_buffer,
		    unsigned int *error_code);
/* optionnal symbols */
/* this symbol isn't documented for the moment, it should contain 0 or the */
/* maximum size of one event, value 0 is safe */
int max_size = 0;
void process_initialise (struct my_struct *algo_data,
			 unsigned int *error_code);
void process_reset (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_start (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_stop (struct my_struct *algo_data,
		   unsigned int *error_code);
void process_pause (struct my_struct *algo_data,
		    unsigned int *error_code);
void process_resume (struct my_struct *algo_data,
		     unsigned int *error_code);
void process_unload (struct my_struct *algo_data,
		     unsigned int *error_code);

/* coding region */

void process_config (char *directory_path, unsigned int *error_code)
{
  printf ("call to process_config\n");
  printf ("directory path = %s\n",directory_path);
  *error_code = 0;
}

struct my_struct *process_register (unsigned int *error_code)
{
  struct my_struct *algo_data;

  algo_data = (struct my_struct *) malloc (sizeof (struct my_struct));
  algo_data->id = next_id;
  next_id++;
  return algo_data;
}

void process_block (struct my_struct *algo_data,
		    void *input_buffer,
                    unsigned int size_of_input_buffer,
		    void *output_buffer,
		    unsigned int size_of_output_buffer,
		    unsigned int *used_size_of_output_buffer,
		    unsigned int *error_code)
{
  unsigned int size_of_output_buffer_in_32_bits_word;
  unsigned int *data_in,*data_out;
  unsigned int i;

  size_of_output_buffer_in_32_bits_word = size_of_input_buffer / 4;
  data_in = (unsigned int *) input_buffer;
  data_out = (unsigned int *) output_buffer;
  data_out [0] = data_in [0] * 10;
  for (i=1;i<size_of_output_buffer_in_32_bits_word;i++)
    {
      data_out [i] = data_in [i];
    }
  *error_code = 0;
  *used_size_of_output_buffer = size_of_output_buffer_in_32_bits_word * 4;
}

void process_initialise (struct my_struct *algo_data,
			 unsigned int *error_code)
{
  printf ("process_initialise called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_reset (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_reset called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_start (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_start called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_stop (struct my_struct *algo_data,
		   unsigned int *error_code)
{
  printf ("process_stop called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_pause (struct my_struct *algo_data,
		    unsigned int *error_code)
{
  printf ("process_pause called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_resume (struct my_struct *algo_data,
		     unsigned int *error_code)
{
  printf ("process_resume called with id=%d\n",algo_data->id);
  /* put your code here */
  *error_code = 0;
}
void process_unload (struct my_struct *algo_data,
		     unsigned int *error_code)
{
  printf ("process_unload called with id=%d\n",algo_data->id);
  /* put your code here */
  free (algo_data);
  *error_code = 0;
}
